/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.samples;

import io.datafx.io.DataReader;
import io.datafx.io.FileSource;
import io.datafx.provider.ObjectDataProvider;
import io.datafx.samples.Book;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

class FileXmlSingleSample {
    public Node getContent(Scene scene) throws IOException {
        TabPane tabPane = new TabPane();
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        tabPane.setPrefWidth(scene.getWidth());
        tabPane.setPrefHeight(scene.getHeight());
        tabPane.prefWidthProperty().bind((ObservableValue)scene.widthProperty());
        tabPane.prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        Tab localTab = new Tab("local");
        this.buildLocalTab(localTab);
        tabPane.getTabs().add((Object)localTab);
        Tab networkTab = new Tab("network");
        this.buildNetworkTab(networkTab);
        tabPane.getTabs().add((Object)networkTab);
        return tabPane;
    }

    private void buildLocalTab(Tab tab) throws IOException {
        try {
            URL resource = this.getClass().getResource("singlebook.xml");
            FileSource dr = new FileSource(new File(resource.getFile()));
            ObjectDataProvider sodp = new ObjectDataProvider((DataReader)dr);
            sodp.retrieve();
            final Label title = new Label("HELLO");
            final ObjectProperty op = sodp.getData();
            op.addListener(new InvalidationListener(){

                public void invalidated(Observable o) {
                    Book book = (Book)op.get();
                    title.setText(book.getTitle());
                }
            });
            tab.setContent((Node)title);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(FileXmlSingleSample.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void buildNetworkTab(Tab tab) {
    }
}

