/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.samples;

import io.datafx.io.DataReader;
import io.datafx.io.RestSource;
import io.datafx.io.converter.InputStreamConverter;
import io.datafx.io.converter.XmlConverter;
import io.datafx.provider.ListDataProvider;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class RestSample {
    public Node getContent(Scene scene) {
        TabPane tabPane = new TabPane();
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        tabPane.setPrefWidth(scene.getWidth());
        tabPane.setPrefHeight(scene.getHeight());
        tabPane.prefWidthProperty().bind((ObservableValue)scene.widthProperty());
        tabPane.prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        Tab localTab = new Tab("local");
        this.buildLocalTab(localTab);
        tabPane.getTabs().add((Object)localTab);
        return tabPane;
    }

    private void buildLocalTab(Tab tab) {
        try {
            XmlConverter converter = new XmlConverter("item", Tweet.class);
            RestSource dr = new RestSource("http://search.twitter.com", (InputStreamConverter)converter);
            dr.setPath("search.rss?q=javafx");
            ListDataProvider sodp = new ListDataProvider((DataReader)dr);
            sodp.retrieve();
            ListProperty op = sodp.getData();
            ListView lv = new ListView((ObservableList)op.get());
            tab.setContent((Node)lv);
        }
        catch (Exception ex) {
            Logger.getLogger(RestSample.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static class Tweet {
        private StringProperty titleProperty = new SimpleStringProperty();
        private StringProperty authorProperty = new SimpleStringProperty();
        private StringProperty pubDateProperty = new SimpleStringProperty();

        public String getTitle() {
            return (String)this.titleProperty.get();
        }

        public void setTitle(String title) {
            this.titleProperty.set((Object)title);
        }

        public StringProperty titleProperty() {
            return this.titleProperty;
        }

        public String getAuthor() {
            return (String)this.authorProperty.get();
        }

        public void setAuthor(String author) {
            this.authorProperty.set((Object)author);
        }

        public StringProperty authorProperty() {
            return this.authorProperty;
        }

        public String getPubDate() {
            return (String)this.pubDateProperty.get();
        }

        public void setPubDate(String date) {
            this.pubDateProperty.set((Object)date);
        }

        public StringProperty pubDateProperty() {
            return this.pubDateProperty;
        }

        public String toString() {
            return this.getPubDate() + "-" + this.getAuthor() + ": " + this.getTitle();
        }
    }
}

