/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.samples.imageloading;

import io.datafx.core.concurrent.ConcurrentUtils;
import io.datafx.core.concurrent.ObservableExecutor;
import java.util.concurrent.ExecutionException;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class ImageLoader {
    private ObservableExecutor executor;
    private Image defaultImage;

    public ImageLoader() {
        this(ObservableExecutor.getDefaultInstance(), null);
    }

    public ImageLoader(ObservableExecutor executor, Image defaultImage) {
        this.executor = executor;
        this.defaultImage = defaultImage;
    }

    public Worker<Void> updateImageView(final ImageView view, final String url) {
        view.setImage(this.defaultImage);
        return this.executor.submit((Task)new Task<Void>(){

            protected Void call() throws Exception {
                this.updateTitle("Loading Image");
                this.updateMessage("Loading Image by URL: " + url);
                Image image = new Image(url, false);
                try {
                    ConcurrentUtils.runAndWait(() -> view.setImage(image));
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public void debug() {
        this.executor.currentServicesProperty().addListener(e -> System.out.println(this.executor.currentServicesProperty().size() + " threads are loading images."));
    }
}

