/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.samples.multitab;

import io.datafx.control.cell.ServiceListCellFactory;
import io.datafx.controller.flow.Flow;
import io.datafx.controller.flow.FlowException;
import io.datafx.core.concurrent.ObservableExecutor;
import io.datafx.samples.app.EditViewController;
import io.datafx.samples.app.LoadPersonsTask;
import io.datafx.samples.app.MasterViewController;
import io.datafx.samples.app.RemoveActionTask;
import io.datafx.samples.jpacrud.TestEntityMasterController;
import io.datafx.samples.multitab.SampleTabController;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.stage.Stage;
import javafx.util.Callback;

public class MultiTabMain
extends Application {
    public static void main(String[] args) {
        MultiTabMain.launch((String[])args);
    }

    public void start(Stage primaryStage) throws Exception {
        BorderPane pane = new BorderPane();
        TabPane tabPane = new TabPane();
        pane.setCenter((Node)tabPane);
        Tab concurrencyOverview = new Tab("Concurrency");
        concurrencyOverview.setClosable(false);
        ListView taskList = new ListView();
        taskList.setItems((ObservableList)ObservableExecutor.getDefaultInstance().currentServicesProperty().get());
        taskList.setCellFactory((Callback)new ServiceListCellFactory());
        concurrencyOverview.setContent((Node)taskList);
        tabPane.getTabs().add((Object)concurrencyOverview);
        FlowPane actionPane = new FlowPane();
        actionPane.setStyle("-fx-background-color: #a9a9a9");
        actionPane.setPadding(new Insets(12.0));
        Button addTabButton = new Button("addFunction");
        addTabButton.setOnAction(e -> this.addTab(tabPane, SampleTabController.class));
        Button addCrudTabButton = new Button("addJpaCrud");
        addCrudTabButton.setOnAction(e -> this.addTab(tabPane, TestEntityMasterController.class));
        Flow flow = new Flow(MasterViewController.class).withLink(MasterViewController.class, "edit", EditViewController.class).withLink(EditViewController.class, "save", MasterViewController.class).withTaskAction(MasterViewController.class, "remove", RemoveActionTask.class).withTaskAction(MasterViewController.class, "load", LoadPersonsTask.class);
        Button addFlowTabButton = new Button("addFlow");
        addFlowTabButton.setOnAction(e -> this.addTab(tabPane, flow));
        actionPane.getChildren().addAll((Object[])new Node[]{addTabButton, addCrudTabButton, addFlowTabButton});
        pane.setTop((Node)actionPane);
        primaryStage.setScene(new Scene((Parent)pane, 640.0, 480.0));
        primaryStage.show();
    }

    private <T> void addTab(TabPane tabPane, Class<T> controllerClass) {
        this.addTab(tabPane, new Flow(controllerClass));
    }

    private <T> void addTab(TabPane tabPane, Flow flow) {
        try {
            tabPane.getTabs().add((Object)flow.startInTab());
        }
        catch (FlowException e) {
            e.printStackTrace();
        }
    }
}

