/*
 * Decompiled with CFR 0.152.
 */
package io.datanerds.verteiler;

import java.util.Properties;

final class KafkaConfigValidator {
    static final String NULL_PROPS_MESSAGE = "Kafka properties must not be null";
    static final String AUTO_COMMIT_ENABLED_MSG = String.format("%s must not be enabled for the BlockingQueueConsumer", "enable.auto.commit");

    private KafkaConfigValidator() {
    }

    public static void validate(Properties props) {
        KafkaConfigValidator.verifyPropsNotNull(props);
        KafkaConfigValidator.verifyAutoCommitDisabled(props);
    }

    private static void verifyPropsNotNull(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException(NULL_PROPS_MESSAGE);
        }
    }

    private static void verifyAutoCommitDisabled(Properties props) {
        Boolean isAutoCommitEnabled = Boolean.parseBoolean(props.getProperty("enable.auto.commit"));
        if (isAutoCommitEnabled.booleanValue()) {
            throw new IllegalArgumentException(AUTO_COMMIT_ENABLED_MSG);
        }
    }
}

