package io.dataspray.opennextcdk;

/**
 * The `Nextjs` construct is a higher level construct that makes it easy to create a NextJS app.
 * <p>
 * Your standalone server application will be bundled using o(utput tracing and will be deployed to a Lambda function.
 * Static assets will be deployed to an S3 bucket and served via CloudFront.
 * You must use Next.js 10.3.0 or newer.
 * <p>
 * Please provide a <code>nextjsPath</code> to the Next.js app inside your project.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * new Nextjs(this, "Web", {
 *   nextjsPath: path.resolve("packages/web"),
 * })
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.80.0 (build bce6a1d)", date = "2023-07-30T03:46:44.230Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = io.dataspray.opennextcdk.$Module.class, fqn = "open-next-cdk.Nextjs")
public class Nextjs extends software.constructs.Construct {

    protected Nextjs(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Nextjs(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Nextjs(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull io.dataspray.opennextcdk.NextjsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket() {
        return software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUrl() {
        return software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Asset deployment to S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull io.dataspray.opennextcdk.NextJsAssetsDeployment getAssetsDeployment() {
        return software.amazon.jsii.Kernel.get(this, "assetsDeployment", software.amazon.jsii.NativeType.forClass(io.dataspray.opennextcdk.NextJsAssetsDeployment.class));
    }

    /**
     * Asset deployment to S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssetsDeployment(final @org.jetbrains.annotations.NotNull io.dataspray.opennextcdk.NextJsAssetsDeployment value) {
        software.amazon.jsii.Kernel.set(this, "assetsDeployment", java.util.Objects.requireNonNull(value, "assetsDeployment is required"));
    }

    /**
     * CloudFront distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull io.dataspray.opennextcdk.NextjsDistribution getDistribution() {
        return software.amazon.jsii.Kernel.get(this, "distribution", software.amazon.jsii.NativeType.forClass(io.dataspray.opennextcdk.NextjsDistribution.class));
    }

    /**
     * CloudFront distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistribution(final @org.jetbrains.annotations.NotNull io.dataspray.opennextcdk.NextjsDistribution value) {
        software.amazon.jsii.Kernel.set(this, "distribution", java.util.Objects.requireNonNull(value, "distribution is required"));
    }

    /**
     * The image optimization handler lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull io.dataspray.opennextcdk.ImageOptimizationLambda getImageOptimizationFunction() {
        return software.amazon.jsii.Kernel.get(this, "imageOptimizationFunction", software.amazon.jsii.NativeType.forClass(io.dataspray.opennextcdk.ImageOptimizationLambda.class));
    }

    /**
     * The image optimization handler lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageOptimizationFunction(final @org.jetbrains.annotations.NotNull io.dataspray.opennextcdk.ImageOptimizationLambda value) {
        software.amazon.jsii.Kernel.set(this, "imageOptimizationFunction", java.util.Objects.requireNonNull(value, "imageOptimizationFunction is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.FunctionUrl getImageOptimizationLambdaFunctionUrl() {
        return software.amazon.jsii.Kernel.get(this, "imageOptimizationLambdaFunctionUrl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionUrl.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageOptimizationLambdaFunctionUrl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.FunctionUrl value) {
        software.amazon.jsii.Kernel.set(this, "imageOptimizationLambdaFunctionUrl", java.util.Objects.requireNonNull(value, "imageOptimizationLambdaFunctionUrl is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.FunctionUrl getLambdaFunctionUrl() {
        return software.amazon.jsii.Kernel.get(this, "lambdaFunctionUrl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionUrl.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLambdaFunctionUrl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.FunctionUrl value) {
        software.amazon.jsii.Kernel.set(this, "lambdaFunctionUrl", java.util.Objects.requireNonNull(value, "lambdaFunctionUrl is required"));
    }

    /**
     * Built NextJS project output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull io.dataspray.opennextcdk.NextjsBuild getNextBuild() {
        return software.amazon.jsii.Kernel.get(this, "nextBuild", software.amazon.jsii.NativeType.forClass(io.dataspray.opennextcdk.NextjsBuild.class));
    }

    /**
     * Built NextJS project output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNextBuild(final @org.jetbrains.annotations.NotNull io.dataspray.opennextcdk.NextjsBuild value) {
        software.amazon.jsii.Kernel.set(this, "nextBuild", java.util.Objects.requireNonNull(value, "nextBuild is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull io.dataspray.opennextcdk.NextjsProps getProps() {
        return software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.forClass(io.dataspray.opennextcdk.NextjsProps.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setProps(final @org.jetbrains.annotations.NotNull io.dataspray.opennextcdk.NextjsProps value) {
        software.amazon.jsii.Kernel.set(this, "props", java.util.Objects.requireNonNull(value, "props is required"));
    }

    /**
     * The main NextJS server handler lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull io.dataspray.opennextcdk.NextJsLambda getServerFunction() {
        return software.amazon.jsii.Kernel.get(this, "serverFunction", software.amazon.jsii.NativeType.forClass(io.dataspray.opennextcdk.NextJsLambda.class));
    }

    /**
     * The main NextJS server handler lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerFunction(final @org.jetbrains.annotations.NotNull io.dataspray.opennextcdk.NextJsLambda value) {
        software.amazon.jsii.Kernel.set(this, "serverFunction", java.util.Objects.requireNonNull(value, "serverFunction is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getStaticAssetBucket() {
        return software.amazon.jsii.Kernel.get(this, "staticAssetBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setStaticAssetBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket value) {
        software.amazon.jsii.Kernel.set(this, "staticAssetBucket", java.util.Objects.requireNonNull(value, "staticAssetBucket is required"));
    }

    /**
     * Where build-time assets for deployment are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTempBuildDir() {
        return software.amazon.jsii.Kernel.get(this, "tempBuildDir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Where build-time assets for deployment are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTempBuildDir(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tempBuildDir", java.util.Objects.requireNonNull(value, "tempBuildDir is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.Bucket getConfigBucket() {
        return software.amazon.jsii.Kernel.get(this, "configBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.Bucket.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigBucket(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.Bucket value) {
        software.amazon.jsii.Kernel.set(this, "configBucket", value);
    }

    /**
     * A fluent builder for {@link io.dataspray.opennextcdk.Nextjs}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<io.dataspray.opennextcdk.Nextjs> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final io.dataspray.opennextcdk.NextjsProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new io.dataspray.opennextcdk.NextjsProps.Builder();
        }

        /**
         * Optional value used to install NextJS node dependencies.
         * <p>
         * It defaults to 'npx --yes open-next&#64;latest build'
         * <p>
         * @return {@code this}
         * @param buildCommand Optional value used to install NextJS node dependencies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildCommand(final java.lang.String buildCommand) {
            this.props.buildCommand(buildCommand);
            return this;
        }

        /**
         * The directory to execute `npm run build` from.
         * <p>
         * By default, it is <code>nextjsPath</code>.
         * Can be overridden, particularly useful for monorepos where <code>build</code> is expected to run
         * at the root of the project.
         * <p>
         * @return {@code this}
         * @param buildPath The directory to execute `npm run build` from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildPath(final java.lang.String buildPath) {
            this.props.buildPath(buildPath);
            return this;
        }

        /**
         * 0 - no compression, fastest 9 - maximum compression, slowest.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param compressionLevel 0 - no compression, fastest 9 - maximum compression, slowest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compressionLevel(final java.lang.Number compressionLevel) {
            this.props.compressionLevel(compressionLevel);
            return this;
        }

        /**
         * Custom environment variables to pass to the NextJS build and runtime.
         * <p>
         * @return {@code this}
         * @param environment Custom environment variables to pass to the NextJS build and runtime. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final java.util.Map<java.lang.String, java.lang.String> environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * (deprecated) Used in conjunction with nextJsPath to skip building NextJS app and assume .open-next folder already exists. Useful when using `next dev` for local development.
         * <p>
         * @return {@code this}
         * @deprecated use `openNextPath` instead
         * @param isPlaceholder Used in conjunction with nextJsPath to skip building NextJS app and assume .open-next folder already exists. Useful when using `next dev` for local development. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder isPlaceholder(final java.lang.Boolean isPlaceholder) {
            this.props.isPlaceholder(isPlaceholder);
            return this;
        }

        /**
         * (deprecated) Relative path to the directory where the NextJS project is located.
         * <p>
         * Can be the root of your project (<code>.</code>) or a subdirectory (<code>packages/web</code>).
         * <p>
         * One of <code>openNextPath</code>, <code>nextJsPath</code> or <code>nextjsPath</code> must be supplied.
         * <p>
         * @return {@code this}
         * @deprecated use `nextJsPath` instead
         * @param nextjsPath Relative path to the directory where the NextJS project is located. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder nextjsPath(final java.lang.String nextjsPath) {
            this.props.nextjsPath(nextjsPath);
            return this;
        }

        /**
         * Relative path to the directory where the NextJS project is located.
         * <p>
         * Can be the root of your project (<code>.</code>) or a subdirectory (<code>packages/web</code>).
         * <p>
         * One of <code>openNextPath</code> or <code>nextJsPath</code> must be supplied.
         * <p>
         * @return {@code this}
         * @param nextJsPath Relative path to the directory where the NextJS project is located. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nextJsPath(final java.lang.String nextJsPath) {
            this.props.nextJsPath(nextJsPath);
            return this;
        }

        /**
         * Optional value for NODE_ENV during build and runtime.
         * <p>
         * @return {@code this}
         * @param nodeEnv Optional value for NODE_ENV during build and runtime. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeEnv(final java.lang.String nodeEnv) {
            this.props.nodeEnv(nodeEnv);
            return this;
        }

        /**
         * Relative path to the OpenNext package named `.open-next` by default.
         * <p>
         * One of <code>openNextPath</code> or <code>nextJsPath</code> must be supplied.
         * <p>
         * @return {@code this}
         * @param openNextPath Relative path to the OpenNext package named `.open-next` by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openNextPath(final java.lang.String openNextPath) {
            this.props.openNextPath(openNextPath);
            return this;
        }

        /**
         * Less build output.
         * <p>
         * @return {@code this}
         * @param quiet Less build output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quiet(final java.lang.Boolean quiet) {
            this.props.quiet(quiet);
            return this;
        }

        /**
         * Optional arn for the sharp lambda layer.
         * <p>
         * If omitted, the layer will be created.
         * <p>
         * @return {@code this}
         * @param sharpLayerArn Optional arn for the sharp lambda layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sharpLayerArn(final java.lang.String sharpLayerArn) {
            this.props.sharpLayerArn(sharpLayerArn);
            return this;
        }

        /**
         * Directory to store temporary build files in.
         * <p>
         * Defaults to os.tmpdir().
         * <p>
         * @return {@code this}
         * @param tempBuildDir Directory to store temporary build files in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tempBuildDir(final java.lang.String tempBuildDir) {
            this.props.tempBuildDir(tempBuildDir);
            return this;
        }

        /**
         * Allows you to override defaults for the resources created by this construct.
         * <p>
         * @return {@code this}
         * @param defaults Allows you to override defaults for the resources created by this construct. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaults(final io.dataspray.opennextcdk.NextjsDefaultsProps defaults) {
            this.props.defaults(defaults);
            return this;
        }

        /**
         * Optional S3 Bucket to use, defaults to assets bucket.
         * <p>
         * @return {@code this}
         * @param imageOptimizationBucket Optional S3 Bucket to use, defaults to assets bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageOptimizationBucket(final software.amazon.awscdk.services.s3.IBucket imageOptimizationBucket) {
            this.props.imageOptimizationBucket(imageOptimizationBucket);
            return this;
        }

        /**
         * @returns a newly built instance of {@link io.dataspray.opennextcdk.Nextjs}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public io.dataspray.opennextcdk.Nextjs build() {
            return new io.dataspray.opennextcdk.Nextjs(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
