/**
 * <h1 align="center">
 *   <div align="center">
 *       <img align="middle" alt="Typescript" src="./resources/typescript.svg" width=15>
 *       <img align="middle" alt="Java" src="./resources/java.svg" width=20>
 *       <img align="middle" alt="Go" src="./resources/go.svg" width=30>
 *       <img align="middle" alt="Python" src="./resources/python.svg" width=15>
 *       <img align="middle" alt=".NET" src="./resources/dotnet.svg" width=30>
 *   </div>
 *   OpenNext CDK
 * </h1>
 * <div align="center">
 *   <a href="https://github.com/datasprayio/open-next-cdk/actions?query=workflow%3A%22build%22">
 *     <img align="middle" alt="Build Status" src="https://img.shields.io/github/actions/workflow/status/datasprayio/open-next-cdk/build.yml?style=for-the-badge">
 *   </a>
 *   <a href="https://github.com/datasprayio/open-next-cdk/blob/master/LICENSE">
 *     <img align="middle" alt="License" src="https://img.shields.io/github/license/datasprayio/open-next-cdk?style=for-the-badge">
 *   </a>
 *   <a href="https://www.npmjs.com/package/open-next-cdk">
 *     <img align="middle" alt="NPM release" src="https://img.shields.io/npm/v/open-next-cdk?label=RELEASE&color=blue&style=for-the-badge">
 *   </a>
 * </div>
 * <h3 align="center">Deploy NextJS on AWS using CDK IaC and OpenNext packaging</h3>
 * <p>
 * <h3>Contents</h3>
 * <p>
 * <ul>
 * <li><a href="#what-is-this">What is this?</a></li>
 * <li><a href="#quickstart">Quickstart</a></li>
 * <li><a href="#requirements">Requirements</a></li>
 * <li><a href="#advanced">Advanced</a>
 * <p>
 * <ul>
 * <li><a href="#pre-built-opennext-package">Pre-built OpenNext package</a></li>
 * <li><a href="#additional-security">Additional security</a></li>
 * </ul></li>
 * <li><a href="#about">About</a>
 * <p>
 * <ul>
 * <li><a href="#benefits">Benefits</a></li>
 * <li><a href="#dependencies">Dependencies</a></li>
 * <li><a href="#similar-projects">Similar projects</a>
 * <p>
 * <ul>
 * <li><a href="#fork-from-cdk-nextjs">Fork from cdk-nextjs</a></li>
 * </ul></li>
 * </ul></li>
 * <li><a href="#contributing">Contributing</a>
 * <p>
 * <ul>
 * <li><a href="#using-projen">Using Projen</a></li>
 * </ul></li>
 * </ul>
 * <p>
 * <h1>What is this?</h1>
 * <p>
 * A building block for Amazon's infrastructure-as-code CDK toolkit to deploy a NextJS app using AWS serverless services.
 * <p>
 * Your NextJS app is packaged using OpenNext to fit the serverless format on Lambda
 * <p>
 * <h1>Requirements</h1>
 * <p>
 * NextJs versions: &gt;=12.3.0+ (includes 13.0.0+)
 * <p>
 * Platforms: darwin-arm64, darwin-x64, linux-arm64, linux-x64, win32-arm64, win32-x64
 * <p>
 * <h1>Quickstart</h1>
 * <p>
 * <h3>NextJS setup</h3>
 * <p>
 * Add a dev dependency <code>esbuild&#64;0.17.16</code> to your NextJS project.
 * <p>
 * <blockquote><pre>
 * npm install --save-dev esbuild&#64;0.17.16
 * </pre></blockquote>
 * <p>
 * <h3>CDK Construct</h3>
 * <p>
 * Use this construct in your CDK application to deploy your NextJS app to AWS.
 * <p>
 * <details>
 *   <summary>Typescript <img align="middle" alt="Typescript" src="./resources/typescript.svg" width=20></summary>  <a href="https://www.npmjs.com/package/open-next-cdk">
 *     <img align="middle" alt="NPM release" src="https://img.shields.io/npm/v/open-next-cdk?style=for-the-badge">
 *   </a>
 * <p>
 * Install the dependency using npm:
 * <p>
 * <blockquote><pre>
 * npm install --save-dev esbuild&#64;0.17.16 open-next-cdk
 * </pre></blockquote>
 * <p>
 * Use the construct in your CDK application:
 * <p>
 * <blockquote><pre>
 * import { Nextjs } from 'open-next-cdk';
 * 
 * new Nextjs(this, 'Web', {
 *   nextjsPath: './web', // relative path to nextjs project root
 * });
 * </pre></blockquote>
 * <p>
 * </details>
 * <details>
 *   <summary>Java <img align="middle" alt="Java" src="./resources/java.svg" width=20></summary>
 *   <a href="https://search.maven.org/artifact/io.dataspray/open-next-cdk">
 *     <img align="middle" alt="Maven Central release" src="https://img.shields.io/maven-central/v/io.dataspray/open-next-cdk?style=for-the-badge">
 *   </a>
 * <p>
 * Install the dependency using Maven:
 * <p>
 * <blockquote><pre>
 * &lt;dependency&gt;
 *   &lt;groupId&gt;io.dataspray&lt;/groupId&gt;
 *   &lt;artifactId&gt;open-next-cdk&lt;/artifactId&gt;
 *   &lt;version&gt;x.y.z&lt;/version&gt;
 * &lt;/dependency&gt;
 * </pre></blockquote>
 * <p>
 * Use the construct in your CDK application:
 * <p>
 * <blockquote><pre>
 * Nextjs.Builder.create(this, getConstructId())
 *         .nextjsPath("./web")
 *         .build();
 * </pre></blockquote>
 * <p>
 * </details>
 * <details>
 *   <summary>Go <img align="middle" alt="Go" src="./resources/go.svg" width=20></summary>  <a href="https://github.com/datasprayio/open-next-cdk/tree/main/opennextcdk">
 *     <img align="middle" alt="Go release" src="https://img.shields.io/github/go-mod/go-version/datasprayio/open-next-cdk/go?filename=opennextcdk%2Fgo.mod&label=GO&style=for-the-badge">
 *   </a>
 * <p>
 * Install the dependency:
 * <p>
 * <blockquote><pre>
 * go get github.com:datasprayio/open-next-cdk.git&#64;go
 * </pre></blockquote>
 * <p>
 * Or checkout <a href="https://github.com/datasprayio/open-next-cdk/tree/go">the code in the <code>go</code> branch</a>.
 * <p>
 * </details>
 * <details>
 *   <summary>Python <img align="middle" alt="Python" src="./resources/python.svg" width=20></summary>  <a href="https://pypi.org/project/open-next-cdk/">
 *     <img align="middle" alt="Pypi release" src="https://img.shields.io/pypi/v/open-next-cdk?style=for-the-badge">
 *   </a>
 * <p>
 * Install the dependency:
 * <p>
 * <blockquote><pre>
 * pip install open-next-cdk
 * </pre></blockquote>
 * <p>
 * </details>
 * <details>
 *   <summary>.NET <img align="middle" alt=".NET" src="./resources/dotnet.svg" width=20></summary>  <a href="https://www.nuget.org/packages/Dataspray.OpenNextCdk">
 *     <img align="middle" alt="Nuget release" src="https://img.shields.io/nuget/v/Dataspray.OpenNextCdk?style=for-the-badge">
 *   </a>
 * <p>
 * Install the dependency:
 * <p>
 * <blockquote><pre>
 * dotnet add package Dataspray.OpenNextCdk
 * </pre></blockquote>
 * <p>
 * </details>
 * <br/>
 * <p>
 * This will automatically build your NextJS app and package it for you as part of the CDK construct.
 * <p>
 * If you would prefer to package it separately, see below:
 * <p>
 * <h1>Advanced</h1>
 * <p>
 * <h3>Pre-built OpenNext package</h3>
 * <p>
 * <details>
 *   <summary>How-to</summary>
 * <p>
 * You may also provide already pre-built OpenNext package directly by building it yourself first:
 * <p>
 * <blockquote><pre>
 * open-next build
 * </pre></blockquote>
 * <p>
 * You will find a new folder <code>.open-next</code> which contains the packaging for your NextJS App. Now you can use the construct by instructing it not to build your app, just use the OpenNext folder directly:
 * <p>
 * <blockquote><pre>
 * import { Nextjs } from 'open-next-cdk';
 * 
 * new Nextjs(this, 'Web', {
 *   openNextPath: './web/.open-next', // relative path to .open-next folder
 * });
 * </pre></blockquote>
 * <p>
 * </details>
 * <p>
 * <h3>Additional security</h3>
 * <p>
 * <details>
 *   <summary>How-to</summary>
 * <p>
 * <blockquote><pre>
 * import { RemovalPolicy, Stack } from "aws-cdk-lib";
 * import { Construct } from "constructs";
 * import { CfnWebAcl } from "aws-cdk-lib/aws-wafv2";
 * import { SecurityPolicyProtocol, type DistributionProps } from "aws-cdk-lib/aws-cloudfront";
 * import { Nextjs, type NextjsDistributionProps } from "cdk-nextjs-standalone";
 * import { Bucket, BlockPublicAccess, BucketEncryption } from "aws-cdk-lib/aws-s3";
 * 
 * // Because of `WebAcl`, this stack must be deployed in us-east-1. If you want
 * // to deploy Nextjs in another region, add WAF in separate stack deployed in us-east-1
 * export class UiStack {
 *   constructor(scope: Construct, id: string) {
 *     const webAcl = new CfnWebAcl(this, "WebAcl", { ... });
 *     new Nextjs(this, "NextSite", {
 *       nextjsPath: "...",
 *       defaults: {
 *         assetDeployment: {
 *           bucket: new Bucket(this, "NextjsAssetDeploymentBucket", {
 *             autoDeleteObjects: true,
 *             removalPolicy: RemovalPolicy.DESTROY,
 *             encryption: BucketEncryption.S3_MANAGED,
 *             enforceSSL: true,
 *             blockPublicAccess: BlockPublicAccess.BLOCK_ALL,
 *           }),
 *         },
 *         distribution: {
 *           functionUrlAuthType: FunctionUrlAuthType.AWS_IAM,
 *           cdk: {
 *             distribution: {
 *               webAclId: webAcl.attrArn,
 *               minimumProtocolVersion: SecurityPolicyProtocol.TLS_V1_2_2021,
 *             } as DistributionProps,
 *           },
 *         } satisfies Partial&lt;NextjsDistributionProps&gt;,
 *       },
 *     });
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * </details>
 * <br />
 * <p>
 * <h1>About</h1>
 * <p>
 * Deploys a NextJs static site with server-side rendering and API support. Uses AWS lambda and CloudFront.
 * <p>
 * There is a new (since Next 12) <a href="https://nextjs.org/docs/advanced-features/output-file-tracing">standalone output mode which uses output tracing</a> to generate a minimal server and static files.
 * This standalone server can be converted into a CloudFront distribution and a lambda handler that handles SSR, API, and routing.
 * <p>
 * The CloudFront default origin first checks S3 for static files and falls back to an HTTP origin using a lambda function URL.
 * <p>
 * <h2>Benefits</h2>
 * <p>
 * This approach is most compatible with new NextJs features such as ESM configuration, <a href="https://nextjs.org/docs/advanced-features/middleware">middleware</a>, next-auth, and React server components ("appDir").
 * <p>
 * The unmaintained <a href="https://github.com/serverless-nextjs/serverless-next.js">&#64;serverless-nextjs project</a> uses the deprecated <code>serverless</code> NextJs build target which <a href="https://github.com/serverless-nextjs/serverless-next.js/pull/2478">prevents the use of new features</a>.
 * This construct was created to use the new <code>standalone</code> output build and newer AWS features like lambda function URLs and fallback origins.
 * <p>
 * You may want to look at <a href="https://sst.dev">Serverless Stack</a> and its <a href="https://docs.sst.dev/constructs/NextjsSite">NextjsSite</a> construct for an improved developer experience if you are building serverless applications on CDK.
 * <p>
 * <h2>Dependencies</h2>
 * <p>
 * Built on top of <a href="https://open-next.js.org/">open-next</a>, which was partially built using the original core of cdk-nextjs-standalone.
 * <p>
 * <h2>Similar projects</h2>
 * <p>
 * This project is heavily based on
 * <p>
 * <ul>
 * <li><a href="https://open-next.js.org/">Open-next</a></li>
 * <li><a href="https://github.com/iiroj/iiro.fi/commit/bd43222032d0dbb765e1111825f64dbb5db851d9">https://github.com/iiroj/iiro.fi/commit/bd43222032d0dbb765e1111825f64dbb5db851d9</a></li>
 * <li><a href="https://github.com/sladg/nextjs-lambda">https://github.com/sladg/nextjs-lambda</a></li>
 * <li><a href="https://github.com/serverless-nextjs/serverless-next.js/tree/master/packages/compat-layers/apigw-lambda-compat">https://github.com/serverless-nextjs/serverless-next.js/tree/master/packages/compat-layers/apigw-lambda-compat</a></li>
 * <li><a href="https://github.com/serverless-stack/sst">Serverless Stack</a>
 * <p>
 * <ul>
 * <li><a href="https://github.com/serverless-stack/sst/blob/master/packages/resources/src/NextjsSite.ts">RemixSite</a> construct</li>
 * <li><a href="https://github.com/serverless-stack/sst/blob/master/packages/resources/src/RemixSite.ts">NextjsSite</a> construct</li>
 * </ul></li>
 * </ul>
 * <p>
 * <h3>Fork from cdk-nextjs</h3>
 * <p>
 * Compatible with: <code>cdk-nextjs</code><a href="https://github.com/jetbridge/cdk-nextjs/releases/tag/v3.2.1">&#64;3.2.1</a>
 * <p>
 * This project has been initially forked from <a href="https://github.com/jetbridge/cdk-nextjs">cdk-nextjs</a> in order to <a href="https://github.com/jetbridge/cdk-nextjs/issues/120#issuecomment-1634926223">publish the package to other langugages</a>. So far notable changes are:
 * <p>
 * <ul>
 * <li>Extended language support: TS, Java, Go, .NET, Python.</li>
 * <li>Extended platform support: darwin-arm64, darwin-x64, linux-arm64, linux-x64, win32-arm64, win32-x64</li>
 * <li>Use pre-built open-next package</li>
 * </ul>
 * <p>
 * <h1>Contributing</h1>
 * <p>
 * Hey there, we value every new contribution a lot 🙏🏼 thank you. Open an issue or a PR and we'll gladly help you out.
 * <p>
 * <h2>Using Projen</h2>
 * <p>
 * Most boilerplate files are pre-generated including package.json. Don't update it directly, rather update <code>.projenrc.js</code> then run <code>yarn projen</code> to re-generate the files.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package io.dataspray.opennextcdk;
