/*
 * Decompiled with CFR 0.152.
 */
package io.ddavison.conductor;

import com.google.common.base.Strings;
import io.ddavison.conductor.Browser;
import io.ddavison.conductor.Conductor;
import io.ddavison.conductor.Config;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.support.ui.Select;

public class Locomotive
implements Conductor<Locomotive> {
    public static final Logger log = LogManager.getLogger(Locomotive.class);
    public Config configuration;
    public WebDriver driver;
    private final int MAX_ATTEMPTS = 5;
    private int attempts = 0;
    public Actions actions;
    private Map<String, String> vars = new HashMap<String, String>();
    public String baseUrl;
    private Pattern p;
    private Matcher m;

    public Locomotive() {
        DesiredCapabilities capabilities;
        final Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream("/default.properties"));
        }
        catch (IOException e) {
            this.logFatal("Couldn't load in default properties");
        }
        catch (Exception e) {
            // empty catch block
        }
        final Config testConfiguration = this.getClass().getAnnotation(Config.class);
        this.configuration = new Config(){

            @Override
            public String url() {
                String url = "";
                if (!StringUtils.isEmpty((CharSequence)Locomotive.getJvmProperty("CONDUCTOR_URL"))) {
                    url = Locomotive.getJvmProperty("CONDUCTOR_URL");
                }
                if (!StringUtils.isEmpty((CharSequence)props.getProperty("url"))) {
                    url = props.getProperty("url");
                }
                if (testConfiguration != null && !StringUtils.isEmpty((CharSequence)testConfiguration.url())) {
                    url = testConfiguration.url();
                }
                return url;
            }

            @Override
            public Browser browser() {
                Browser browser = Browser.NONE;
                if (!StringUtils.isEmpty((CharSequence)Locomotive.getJvmProperty("CONDUCTOR_BROWSER"))) {
                    browser = Browser.valueOf(Locomotive.getJvmProperty("CONDUCTOR_BROWSER").toUpperCase());
                }
                if (testConfiguration != null && testConfiguration.browser() != Browser.NONE) {
                    return testConfiguration.browser();
                }
                if (!StringUtils.isEmpty((CharSequence)props.getProperty("browser"))) {
                    browser = Browser.valueOf(props.getProperty("browser").toUpperCase());
                }
                return browser;
            }

            @Override
            public String hub() {
                String hub = "";
                if (!StringUtils.isEmpty((CharSequence)Locomotive.getJvmProperty("CONDUCTOR_HUB"))) {
                    hub = Locomotive.getJvmProperty("CONDUCTOR_HUB");
                }
                if (!StringUtils.isEmpty((CharSequence)props.getProperty("hub"))) {
                    hub = props.getProperty("hub");
                }
                if (testConfiguration != null && !StringUtils.isEmpty((CharSequence)testConfiguration.hub())) {
                    hub = testConfiguration.hub();
                }
                return hub;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return null;
            }
        };
        this.baseUrl = this.configuration.url();
        log.debug(String.format("\n=== Configuration ===\n\tURL:     %s\n\tBrowser: %s\n\tHub:     %s\n", this.configuration.url(), this.configuration.browser().moniker, this.configuration.hub()));
        boolean isLocal = StringUtils.isEmpty((CharSequence)this.configuration.hub());
        switch (this.configuration.browser()) {
            case CHROME: {
                capabilities = DesiredCapabilities.chrome();
                if (!isLocal) break;
                try {
                    this.driver = new ChromeDriver((Capabilities)capabilities);
                }
                catch (Exception x) {
                    this.logFatal("chromedriver not found. See https://github.com/ddavison/conductor/wiki/WebDriver-Executables for more information.");
                    System.exit(1);
                }
                break;
            }
            case FIREFOX: {
                capabilities = DesiredCapabilities.firefox();
                if (!isLocal) break;
                this.driver = new FirefoxDriver((Capabilities)capabilities);
                break;
            }
            case INTERNET_EXPLORER: {
                this.logFatal("iedriver not found. See https://github.com/ddavison/conductor/wiki/WebDriver-Executables for more information.");
                System.exit(1);
                capabilities = DesiredCapabilities.internetExplorer();
                if (!isLocal) break;
                this.driver = new InternetExplorerDriver((Capabilities)capabilities);
                break;
            }
            case SAFARI: {
                this.logFatal("safaridriver not found. See https://github.com/ddavison/conductor/wiki/WebDriver-Executables for more information.");
                System.exit(1);
                capabilities = DesiredCapabilities.safari();
                if (!isLocal) break;
                this.driver = new SafariDriver((Capabilities)capabilities);
                break;
            }
            case HTMLUNIT: {
                capabilities = DesiredCapabilities.htmlUnitWithJs();
                if (!isLocal) break;
                this.driver = new HtmlUnitDriver((Capabilities)capabilities);
                break;
            }
            case PHANTOMJS: {
                capabilities = DesiredCapabilities.phantomjs();
                if (!isLocal) break;
                try {
                    this.driver = new PhantomJSDriver((Capabilities)capabilities);
                }
                catch (Exception x) {
                    this.logFatal("phantomjs not found. Download them from https://bitbucket.org/ariya/phantomjs/downloads/ and extract the binary as phantomjs.exe, phantomjs.linux, or phantomjs.mac at project root for Windows, Linux, or MacOS.");
                    System.exit(1);
                }
                break;
            }
            default: {
                System.err.println("Unknown browser: " + (Object)((Object)this.configuration.browser()));
                return;
            }
        }
        if (!isLocal) {
            try {
                this.driver = new RemoteWebDriver(new URL(this.configuration.hub()), (Capabilities)capabilities);
            }
            catch (Exception x) {
                this.logFatal("Couldn't connect to hub: " + this.configuration.hub());
                x.printStackTrace();
                return;
            }
        }
        this.actions = new Actions(this.driver);
        this.driver.navigate().to(this.baseUrl);
    }

    private static String getJvmProperty(String prop) {
        return System.getProperty(prop, System.getenv(prop));
    }

    public static String findFile(String filename) {
        String[] paths;
        for (String path : paths = new String[]{"", "bin/", "target/classes"}) {
            if (!new File(path + filename).exists()) continue;
            return path + filename;
        }
        return "";
    }

    @After
    public void teardown() {
        this.driver.quit();
    }

    @Override
    public WebElement waitForElement(By by) {
        int attempts = 0;
        int size = this.driver.findElements(by).size();
        while (size == 0) {
            size = this.driver.findElements(by).size();
            if (attempts == 5) {
                Assert.fail((String)String.format("Could not find %s after %d seconds", by.toString(), 5));
            }
            ++attempts;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception x) {
                Assert.fail((String)"Failed due to an exception during Thread.sleep!");
                x.printStackTrace();
            }
        }
        if (size > 1) {
            System.err.println("WARN: There are more than 1 " + by.toString() + " 's!");
        }
        return this.driver.findElement(by);
    }

    @Override
    public Locomotive click(String css) {
        return this.click(By.cssSelector((String)css));
    }

    @Override
    public Locomotive click(By by) {
        this.waitForElement(by).click();
        return this;
    }

    @Override
    public Locomotive setText(String css, String text) {
        return this.setText(By.cssSelector((String)css), text);
    }

    @Override
    public Locomotive setText(By by, String text) {
        WebElement element = this.waitForElement(by);
        element.clear();
        element.sendKeys(new CharSequence[]{text});
        return this;
    }

    @Override
    public Locomotive hoverOver(String css) {
        return this.hoverOver(By.cssSelector((String)css));
    }

    @Override
    public Locomotive hoverOver(By by) {
        this.actions.moveToElement(this.driver.findElement(by)).perform();
        return this;
    }

    @Override
    public boolean isChecked(String css) {
        return this.isChecked(By.cssSelector((String)css));
    }

    @Override
    public boolean isChecked(By by) {
        return this.waitForElement(by).isSelected();
    }

    @Override
    public boolean isPresent(String css) {
        return this.isPresent(By.cssSelector((String)css));
    }

    @Override
    public boolean isPresent(By by) {
        return this.driver.findElements(by).size() > 0;
    }

    @Override
    public String getText(String css) {
        return this.getText(By.cssSelector((String)css));
    }

    @Override
    public String getText(By by) {
        WebElement e = this.waitForElement(by);
        String text = e.getTagName().equalsIgnoreCase("input") || e.getTagName().equalsIgnoreCase("select") ? e.getAttribute("value") : e.getText();
        return text;
    }

    @Override
    public String getAttribute(String css, String attribute) {
        return this.getAttribute(By.cssSelector((String)css), attribute);
    }

    @Override
    public String getAttribute(By by, String attribute) {
        return this.waitForElement(by).getAttribute(attribute);
    }

    @Override
    public Locomotive check(String css) {
        return this.check(By.cssSelector((String)css));
    }

    @Override
    public Locomotive check(By by) {
        if (!this.isChecked(by)) {
            this.waitForElement(by).click();
            Assert.assertTrue((String)(by.toString() + " did not check!"), (boolean)this.isChecked(by));
        }
        return this;
    }

    @Override
    public Locomotive uncheck(String css) {
        return this.uncheck(By.cssSelector((String)css));
    }

    @Override
    public Locomotive uncheck(By by) {
        if (this.isChecked(by)) {
            this.waitForElement(by).click();
            Assert.assertFalse((String)(by.toString() + " did not uncheck!"), (boolean)this.isChecked(by));
        }
        return this;
    }

    @Override
    public Locomotive selectOptionByText(String css, String text) {
        return this.selectOptionByText(By.cssSelector((String)css), text);
    }

    @Override
    public Locomotive selectOptionByText(By by, String text) {
        Select box = new Select(this.waitForElement(by));
        box.selectByVisibleText(text);
        return this;
    }

    @Override
    public Locomotive selectOptionByValue(String css, String value) {
        return this.selectOptionByValue(By.cssSelector((String)css), value);
    }

    @Override
    public Locomotive selectOptionByValue(By by, String value) {
        Select box = new Select(this.waitForElement(by));
        box.selectByValue(value);
        return this;
    }

    @Override
    public Locomotive waitForWindow(String regex) {
        Set windows = this.driver.getWindowHandles();
        for (String window : windows) {
            try {
                this.driver.switchTo().window(window);
                this.p = Pattern.compile(regex);
                this.m = this.p.matcher(this.driver.getCurrentUrl());
                if (this.m.find()) {
                    this.attempts = 0;
                    return this.switchToWindow(regex);
                }
                this.m = this.p.matcher(this.driver.getTitle());
                if (!this.m.find()) continue;
                this.attempts = 0;
                return this.switchToWindow(regex);
            }
            catch (NoSuchWindowException e) {
                if (this.attempts <= 5) {
                    ++this.attempts;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    return this.waitForWindow(regex);
                }
                Assert.fail((String)("Window with url|title: " + regex + " did not appear after " + 5 + " tries. Exiting."));
            }
        }
        if (this.attempts == 5) {
            Assert.fail((String)("Window with title: " + regex + " did not appear after 5 tries. Exiting."));
            return this;
        }
        System.out.println("#waitForWindow() : Window doesn't exist yet. [" + regex + "] Trying again. " + this.attempts + "/" + 5);
        ++this.attempts;
        try {
            Thread.sleep(1000L);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return this.waitForWindow(regex);
    }

    @Override
    public Locomotive switchToWindow(String regex) {
        Set windows = this.driver.getWindowHandles();
        for (String window : windows) {
            this.driver.switchTo().window(window);
            System.out.println(String.format("#switchToWindow() : title=%s ; url=%s", this.driver.getTitle(), this.driver.getCurrentUrl()));
            this.p = Pattern.compile(regex);
            this.m = this.p.matcher(this.driver.getTitle());
            if (this.m.find()) {
                return this;
            }
            this.m = this.p.matcher(this.driver.getCurrentUrl());
            if (!this.m.find()) continue;
            return this;
        }
        Assert.fail((String)("Could not switch to window with title / url: " + regex));
        return this;
    }

    @Override
    public Locomotive closeWindow(String regex) {
        if (regex == null) {
            this.driver.close();
            if (this.driver.getWindowHandles().size() == 1) {
                this.driver.switchTo().window((String)this.driver.getWindowHandles().iterator().next());
            }
            return this;
        }
        Set windows = this.driver.getWindowHandles();
        for (String window : windows) {
            try {
                this.driver.switchTo().window(window);
                this.p = Pattern.compile(regex);
                this.m = this.p.matcher(this.driver.getTitle());
                if (this.m.find()) {
                    this.switchToWindow(regex);
                    this.driver.close();
                    if (windows.size() != 2) continue;
                    this.driver.switchTo().window((String)windows.iterator().next());
                    continue;
                }
                this.m = this.p.matcher(this.driver.getCurrentUrl());
                if (!this.m.find()) continue;
                this.switchToWindow(regex);
                this.driver.close();
                if (windows.size() != 2) continue;
                this.driver.switchTo().window((String)windows.iterator().next());
            }
            catch (NoSuchWindowException e) {
                Assert.fail((String)("Cannot close a window that doesn't exist. [" + regex + "]"));
            }
        }
        return this;
    }

    @Override
    public Locomotive closeWindow() {
        return this.closeWindow(null);
    }

    @Override
    public Locomotive switchToFrame(String idOrName) {
        try {
            this.driver.switchTo().frame(idOrName);
        }
        catch (Exception x) {
            Assert.fail((String)("Couldn't switch to frame with id or name [" + idOrName + "]"));
        }
        return this;
    }

    @Override
    public Locomotive switchToFrame(int index) {
        try {
            this.driver.switchTo().frame(index);
        }
        catch (Exception x) {
            Assert.fail((String)("Couldn't switch to frame with an index of [" + index + "]"));
        }
        return this;
    }

    @Override
    public Locomotive switchToDefaultContent() {
        this.driver.switchTo().defaultContent();
        return this;
    }

    @Override
    public Locomotive validatePresent(String css) {
        return this.validatePresent(By.cssSelector((String)css));
    }

    @Override
    public Locomotive validatePresent(By by) {
        this.waitForElement(by);
        Assert.assertTrue((String)("Element " + by.toString() + " does not exist!"), (boolean)this.isPresent(by));
        return this;
    }

    @Override
    public Locomotive validateNotPresent(String css) {
        return this.validateNotPresent(By.cssSelector((String)css));
    }

    @Override
    public Locomotive validateNotPresent(By by) {
        Assert.assertFalse((String)("Element " + by.toString() + " exists!"), (boolean)this.isPresent(by));
        return this;
    }

    @Override
    public Locomotive validateText(String css, String text) {
        return this.validateText(By.cssSelector((String)css), text);
    }

    @Override
    public Locomotive validateText(By by, String text) {
        String actual = this.getText(by);
        Assert.assertTrue((String)String.format("Text does not match! [expected: %s] [actual: %s]", text, actual), (boolean)text.equals(actual));
        return this;
    }

    @Override
    public Locomotive setAndValidateText(By by, String text) {
        return this.setText(by, text).validateText(by, text);
    }

    @Override
    public Locomotive setAndValidateText(String css, String text) {
        return this.setText(css, text).validateText(css, text);
    }

    @Override
    public Locomotive validateTextNot(String css, String text) {
        return this.validateTextNot(By.cssSelector((String)css), text);
    }

    @Override
    public Locomotive validateTextNot(By by, String text) {
        String actual = this.getText(by);
        Assert.assertFalse((String)String.format("Text matches! [expected: %s] [actual: %s]", text, actual), (boolean)text.equals(actual));
        return this;
    }

    @Override
    public Locomotive validateTextPresent(String text) {
        Assert.assertTrue((boolean)this.driver.getPageSource().contains(text));
        return this;
    }

    @Override
    public Locomotive validateTextNotPresent(String text) {
        Assert.assertFalse((boolean)this.driver.getPageSource().contains(text));
        return this;
    }

    @Override
    public Locomotive validateChecked(String css) {
        return this.validateChecked(By.cssSelector((String)css));
    }

    @Override
    public Locomotive validateChecked(By by) {
        Assert.assertTrue((String)(by.toString() + " is not checked!"), (boolean)this.isChecked(by));
        return this;
    }

    @Override
    public Locomotive validateUnchecked(String css) {
        return this.validateUnchecked(By.cssSelector((String)css));
    }

    @Override
    public Locomotive validateUnchecked(By by) {
        Assert.assertFalse((String)(by.toString() + " is not unchecked!"), (boolean)this.isChecked(by));
        return this;
    }

    @Override
    public Locomotive validateAttribute(String css, String attr, String regex) {
        return this.validateAttribute(By.cssSelector((String)css), attr, regex);
    }

    @Override
    public Locomotive validateAttribute(By by, String attr, String regex) {
        String actual = null;
        try {
            actual = this.driver.findElement(by).getAttribute(attr);
            if (actual.equals(regex)) {
                return this;
            }
        }
        catch (NoSuchElementException e) {
            Assert.fail((String)("No such element [" + by.toString() + "] exists."));
        }
        catch (Exception x) {
            Assert.fail((String)"Cannot validate an attribute if an element doesn't have it!");
        }
        this.p = Pattern.compile(regex);
        this.m = this.p.matcher(actual);
        Assert.assertTrue((String)String.format("Attribute doesn't match! [Selector: %s] [Attribute: %s] [Desired value: %s] [Actual value: %s]", by.toString(), attr, regex, actual), (boolean)this.m.find());
        return this;
    }

    @Override
    public Locomotive validateUrl(String regex) {
        this.p = Pattern.compile(regex);
        this.m = this.p.matcher(this.driver.getCurrentUrl());
        Assert.assertTrue((String)("Url does not match regex [" + regex + "] (actual is: \"" + this.driver.getCurrentUrl() + "\")"), (boolean)this.m.find());
        return this;
    }

    @Override
    public Locomotive validateTrue(boolean condition) {
        Assert.assertTrue((boolean)condition);
        return this;
    }

    @Override
    public Locomotive validateFalse(boolean condition) {
        Assert.assertFalse((boolean)condition);
        return this;
    }

    @Override
    public Locomotive goBack() {
        this.driver.navigate().back();
        return this;
    }

    @Override
    public Locomotive navigateTo(String url) {
        if (url.contains("://")) {
            this.driver.navigate().to(url);
        } else if (url.startsWith("/")) {
            this.driver.navigate().to(this.baseUrl.concat(url));
        } else {
            this.driver.navigate().to(this.driver.getCurrentUrl().concat(url));
        }
        return this;
    }

    @Override
    public Locomotive store(String key, String value) {
        this.vars.put(key, value);
        return this;
    }

    @Override
    public String get(String key) {
        return this.get(key, null);
    }

    @Override
    public String get(String key, String defaultValue) {
        if (Strings.isNullOrEmpty((String)this.vars.get(key))) {
            return defaultValue;
        }
        return this.vars.get(key);
    }

    @Override
    public Locomotive log(Object object) {
        return this.logInfo(object);
    }

    @Override
    public Locomotive logInfo(Object object) {
        log.info(object);
        return this;
    }

    @Override
    public Locomotive logWarn(Object object) {
        log.warn(object);
        return this;
    }

    @Override
    public Locomotive logError(Object object) {
        log.error(object);
        return this;
    }

    @Override
    public Locomotive logDebug(Object object) {
        log.debug(object);
        return this;
    }

    @Override
    public Locomotive logFatal(Object object) {
        log.fatal(object);
        return this;
    }

    static {
        if (Locomotive.getJvmProperty("os.name").toLowerCase().contains("mac")) {
            System.setProperty("webdriver.chrome.driver", Locomotive.findFile("chromedriver.mac"));
            System.setProperty("webdriver.firefox.driver", "");
        } else if (Locomotive.getJvmProperty("os.name").toLowerCase().contains("nix") || Locomotive.getJvmProperty("os.name").toLowerCase().contains("nux") || Locomotive.getJvmProperty("os.name").toLowerCase().contains("aix")) {
            System.setProperty("webdriver.chrome.driver", Locomotive.findFile("chromedriver.linux"));
            System.setProperty("webdriver.firefox.driver", "");
        } else if (Locomotive.getJvmProperty("os.name").toLowerCase().contains("win")) {
            System.setProperty("webdriver.chrome.driver", Locomotive.findFile("chromedriver.exe"));
            System.setProperty("webdriver.ie.driver", Locomotive.findFile("iedriver.exe"));
            System.setProperty("webdriver.firefox.driver", "");
        }
    }
}

