/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.engine;

import io.debezium.DebeziumException;
import io.debezium.common.annotation.Incubating;
import io.debezium.engine.ChangeEventFormat;
import io.debezium.engine.spi.OffsetCommitPolicy;
import java.io.Closeable;
import java.time.Clock;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

@Incubating
public interface DebeziumEngine<R>
extends Runnable,
Closeable {
    public static final String OFFSET_FLUSH_INTERVAL_MS_PROP = "offset.flush.interval.ms";

    public static <T> Builder<T> create(Class<? extends ChangeEventFormat<T>> eventFormat) {
        ServiceLoader<Builder> loader = ServiceLoader.load(Builder.class);
        Iterator<Builder> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new DebeziumException("No implementation of Debezium engine builder was found");
        }
        Builder builder = iterator.next();
        if (iterator.hasNext()) {
            LoggerFactory.getLogger(Builder.class).warn("More than one Debezium engine builder implementation was found, using {}", builder.getClass());
        }
        return builder;
    }

    public static interface Builder<R> {
        public Builder<R> notifying(Consumer<R> var1);

        public Builder<R> notifying(ChangeConsumer<R> var1);

        public Builder<R> using(Properties var1);

        public Builder<R> using(ClassLoader var1);

        public Builder<R> using(Clock var1);

        public Builder<R> using(CompletionCallback var1);

        public Builder<R> using(ConnectorCallback var1);

        public Builder<R> using(OffsetCommitPolicy var1);

        public DebeziumEngine<R> build();
    }

    public static interface ChangeConsumer<R> {
        public void handleBatch(List<R> var1, RecordCommitter<R> var2) throws InterruptedException;
    }

    public static interface RecordCommitter<R> {
        public void markProcessed(R var1) throws InterruptedException;

        public void markBatchFinished();
    }

    public static interface ConnectorCallback {
        default public void connectorStarted() {
        }

        default public void connectorStopped() {
        }

        default public void taskStarted() {
        }

        default public void taskStopped() {
        }
    }

    public static interface CompletionCallback {
        public void handle(boolean var1, String var2, Throwable var3);
    }
}

