/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.checkstyle;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.InvalidJavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTags;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavaDocUtil {
    private JavaDocUtil() {
    }

    public static JavadocTags getJavadocTags(TextBlock aCmt, JavadocUtil.JavadocTagType aTagType) {
        String[] text = aCmt.getText();
        ArrayList tags = Lists.newArrayList();
        ArrayList invalidTags = Lists.newArrayList();
        Pattern blockTagPattern = CommonUtil.createPattern((String)"/\\*{2,}\\s*@(\\p{Alpha}+)\\s");
        for (int i = 0; i < text.length; ++i) {
            String s = text[i];
            Matcher blockTagMatcher = blockTagPattern.matcher(s);
            if ((aTagType.equals((Object)JavadocUtil.JavadocTagType.ALL) || aTagType.equals((Object)JavadocUtil.JavadocTagType.BLOCK)) && blockTagMatcher.find()) {
                String tagName = blockTagMatcher.group(1);
                String content = s.substring(blockTagMatcher.end(1));
                if (content.endsWith("*/")) {
                    content = content.substring(0, content.length() - 2);
                }
                int line = aCmt.getStartLineNo() + i;
                int col = blockTagMatcher.start(1) - 1;
                if (i == 0) {
                    col += aCmt.getStartColNo();
                }
                if (JavadocTagInfo.isValidName((String)tagName)) {
                    tags.add(new JavadocTag(line, col, tagName, content.trim()));
                } else {
                    invalidTags.add(new InvalidJavadocTag(line, col, tagName));
                }
            } else if (aTagType.equals((Object)JavadocUtil.JavadocTagType.ALL) || aTagType.equals((Object)JavadocUtil.JavadocTagType.INLINE)) {
                int commentOffset;
                String commentContents;
                Pattern commentPattern = CommonUtil.createPattern((String)"^\\s*(?:/\\*{2,}|\\*+)\\s*(.*)");
                Matcher commentMatcher = commentPattern.matcher(s);
                if (!commentMatcher.find()) {
                    commentContents = s;
                    commentOffset = 0;
                } else {
                    commentContents = commentMatcher.group(1);
                    commentOffset = commentMatcher.start(1) - 1;
                }
                Pattern tagPattern = CommonUtil.createPattern((String)".*?\\{@(\\p{Alpha}+)\\s+([^\\}]*)");
                Matcher tagMatcher = tagPattern.matcher(commentContents);
                while (tagMatcher.find()) {
                    if (tagMatcher.groupCount() != 2) continue;
                    String tagName = tagMatcher.group(1);
                    String tagValue = tagMatcher.group(2).trim();
                    int line = aCmt.getStartLineNo() + i;
                    int col = commentOffset + (tagMatcher.start(1) - 1);
                    if (i == 0) {
                        col += aCmt.getStartColNo();
                    }
                    if (JavadocTagInfo.isValidName((String)tagName)) {
                        tags.add(new JavadocTag(line, col, tagName, tagValue));
                        continue;
                    }
                    invalidTags.add(new InvalidJavadocTag(line, col, tagName));
                }
            }
            blockTagPattern = CommonUtil.createPattern((String)"^\\s*\\**\\s*@(\\p{Alpha}+)\\s");
        }
        return new JavadocTags((List)tags, (List)invalidTags);
    }
}

