/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.binlog.AbstractBinlogConnectorIT;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BinlogBinaryModeIT<C extends SourceConnector>
extends AbstractBinlogConnectorIT<C> {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-binary-mode.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = TestHelper.getUniqueDatabase("binarymodeit", "binary_mode_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-1814"})
    public void shouldReceiveRawBinaryStreaming() throws InterruptedException {
        this.consume(BinlogConnectorConfig.SnapshotMode.NEVER, CommonConnectorConfig.BinaryHandlingMode.BYTES, 1, ByteBuffer.wrap(new byte[]{1, 2, 3}));
    }

    @Test
    @FixFor(value={"DBZ-8076"})
    public void shouldReceiveRawBinarySnapshot() throws InterruptedException {
        this.consume(BinlogConnectorConfig.SnapshotMode.INITIAL, CommonConnectorConfig.BinaryHandlingMode.BYTES, 5, ByteBuffer.wrap(new byte[]{1, 2, 3}));
    }

    @Test
    @FixFor(value={"DBZ-1814"})
    public void shouldReceiveHexBinaryStreaming() throws InterruptedException {
        this.consume(BinlogConnectorConfig.SnapshotMode.NEVER, CommonConnectorConfig.BinaryHandlingMode.HEX, 1, "010203");
    }

    @Test
    @FixFor(value={"DBZ-8076"})
    public void shouldReceiveHexBinarySnapshot() throws InterruptedException {
        this.consume(BinlogConnectorConfig.SnapshotMode.INITIAL, CommonConnectorConfig.BinaryHandlingMode.HEX, 5, "010203");
    }

    @Test
    @FixFor(value={"DBZ-1814"})
    public void shouldReceiveBase64BinaryStream() throws InterruptedException {
        this.consume(BinlogConnectorConfig.SnapshotMode.NEVER, CommonConnectorConfig.BinaryHandlingMode.BASE64, 1, "AQID");
    }

    @Test
    @FixFor(value={"DBZ-8076"})
    public void shouldReceiveBase64BinarySnapshot() throws InterruptedException {
        this.consume(BinlogConnectorConfig.SnapshotMode.INITIAL, CommonConnectorConfig.BinaryHandlingMode.BASE64, 5, "AQID");
    }

    @Test
    @FixFor(value={"DBZ-5544"})
    public void shouldReceiveBase64UrlSafeBinaryStream() throws InterruptedException {
        this.consume(BinlogConnectorConfig.SnapshotMode.NEVER, CommonConnectorConfig.BinaryHandlingMode.BASE64_URL_SAFE, 1, "AQID");
    }

    @Test
    @FixFor(value={"DBZ-8076"})
    public void shouldReceiveBase64UrlSafeBinarySnapshot() throws InterruptedException {
        this.consume(BinlogConnectorConfig.SnapshotMode.INITIAL, CommonConnectorConfig.BinaryHandlingMode.BASE64_URL_SAFE, 5, "AQID");
    }

    private void consume(BinlogConnectorConfig.SnapshotMode snapshotMode, CommonConnectorConfig.BinaryHandlingMode binaryHandlingMode, int metadataEventCount, Object expectedValue) throws InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)snapshotMode)).with(BinlogConnectorConfig.BINARY_HANDLING_MODE, (EnumeratedValue)binaryHandlingMode)).build();
        this.start(this.getConnectorClass(), this.config);
        int createTableCount = 1;
        int insertCount = 1;
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(metadataEventCount + createTableCount + insertCount);
        this.stopConnector();
        Assertions.assertThat((Object)sourceRecords).isNotNull();
        List topicSourceRecords = sourceRecords.recordsForTopic(this.DATABASE.topicForTable("dbz_1814_binary_mode_test"));
        Assertions.assertThat((List)topicSourceRecords).hasSize(1);
        SourceRecord topicSourceRecord = (SourceRecord)topicSourceRecords.get(0);
        Struct kafkaDataStructure = (Struct)((Struct)topicSourceRecord.value()).get("after");
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("blob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("tinyblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("mediumblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("longblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("binary_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("varbinary_col"));
        sourceRecords.forEach(x$0 -> this.validate((SourceRecord)x$0));
    }
}

