/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogConnectorTest;
import io.debezium.connector.binlog.util.BinlogTestConnection;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.converters.AbstractCloudEventsConverterTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.UUID;
import org.apache.kafka.connect.source.SourceConnector;
import org.junit.After;
import org.junit.Before;

public abstract class BinlogCloudEventsConverterIT<C extends SourceConnector>
extends AbstractCloudEventsConverterTest<C>
implements BinlogConnectorTest<C> {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-connect.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = TestHelper.getUniqueDatabase("myServer1", "empty").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private JdbcConnection connection;
    private static final String SETUP_TABLE = "CREATE TABLE a (  pk            integer      not null,  aa            integer      not null,  CONSTRAINT a_pk PRIMARY KEY (pk));";
    private static final String SETUP_OUTBOX_TABLE = "CREATE TABLE outbox (  id            varchar(36)  not null,  aggregatetype varchar(255) not null,  aggregateid   varchar(255) not null,  event_type    varchar(255) not null,  payload       json,  CONSTRAINT outbox_pk PRIMARY KEY (id));";
    private static final String INSERT_STMT = "INSERT INTO a VALUES (1, 1);";

    @Before
    public void beforeEach() throws Exception {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        try (BinlogTestConnection db = this.getTestDatabaseConnection(this.DATABASE.getDatabaseName());){
            this.connection = db.connect();
        }
        super.beforeEach();
    }

    @After
    public void afterEach() throws Exception {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    protected String getServerName() {
        return this.DATABASE.getServerName();
    }

    protected JdbcConnection databaseConnection() {
        return this.connection;
    }

    protected Configuration.Builder getConfigurationBuilder() {
        return (Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.NEVER)).with(BinlogConnectorConfig.INCLUDE_SCHEMA_CHANGES, false);
    }

    protected String topicName() {
        return this.DATABASE.topicForTable("a");
    }

    protected String topicNameOutbox() {
        return this.DATABASE.topicForTable("outbox");
    }

    protected void createTable() throws Exception {
        this.connection.execute(new String[]{SETUP_TABLE});
    }

    protected void createOutboxTable() throws Exception {
        this.connection.execute(new String[]{SETUP_OUTBOX_TABLE});
    }

    protected String createInsert() {
        return INSERT_STMT;
    }

    protected String createInsertToOutbox(String eventId, String eventType, String aggregateType, String aggregateId, String payloadJson, String additional) {
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO outbox VALUES (");
        insert.append("'").append(UUID.fromString(eventId)).append("'");
        insert.append(", '").append(aggregateType).append("'");
        insert.append(", '").append(aggregateId).append("'");
        insert.append(", '").append(eventType).append("'");
        if (payloadJson == null) {
            insert.append(", null");
        } else if (payloadJson.isEmpty()) {
            insert.append(", ''");
        } else {
            insert.append(", '").append(payloadJson).append("'");
        }
        if (additional != null) {
            insert.append(additional);
        }
        insert.append(")");
        return insert.toString();
    }

    protected void waitForStreamingStarted() throws InterruptedException {
        BinlogCloudEventsConverterIT.waitForStreamingRunning((String)this.getConnectorName(), (String)this.DATABASE.getServerName());
    }

    private TableId tableNameId() {
        return this.tableNameId("a");
    }

    private TableId tableNameId(String table) {
        return TableId.parse((String)this.DATABASE.qualifiedTableName(table));
    }
}

