/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.Field;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogConnectorTest;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.source.SourceConnector;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public abstract class BinlogConnectorConfigTest<C extends SourceConnector>
implements BinlogConnectorTest<C> {
    @Test
    public void shouldReturnConfigurationDefinition() {
        BinlogConnectorConfigTest.assertConfigDefIsValid(this.getConnectorInstance(), this.getAllFields());
    }

    protected static void assertConfigDefIsValid(Connector connector, Field.Set fields) {
        ConfigDef configDef = connector.config();
        Assertions.assertThat((Object)configDef).isNotNull();
        fields.forEach(expected -> {
            Assertions.assertThat((Iterable)configDef.names()).contains((Object[])new String[]{expected.name()});
            ConfigDef.ConfigKey key = (ConfigDef.ConfigKey)configDef.configKeys().get(expected.name());
            Assertions.assertThat((Object)key).isNotNull();
            Assertions.assertThat((String)key.name).isEqualTo((Object)expected.name());
            Assertions.assertThat((String)key.displayName).isEqualTo((Object)expected.displayName());
            Assertions.assertThat((Comparable)key.importance).isEqualTo((Object)expected.importance());
            Assertions.assertThat((String)key.documentation).isEqualTo((Object)expected.description());
            Assertions.assertThat((Comparable)key.type).isEqualTo((Object)expected.type());
            if (expected.type() == ConfigDef.Type.CLASS) {
                Assertions.assertThat((String)((Class)key.defaultValue).getName()).isEqualTo((Object)((String)expected.defaultValue()));
            } else if (expected.type() == ConfigDef.Type.LIST && key.defaultValue != null) {
                Assertions.assertThat((Object)key.defaultValue).isEqualTo(Arrays.asList(expected.defaultValue()));
            } else if (!expected.equals((Object)BinlogConnectorConfig.SERVER_ID)) {
                Assertions.assertThat((Object)key.defaultValue).isEqualTo(expected.defaultValue());
            }
            Assertions.assertThat((List)key.dependents).isEqualTo((Object)expected.dependents());
            Assertions.assertThat((Comparable)key.width).isNotNull();
            Assertions.assertThat((String)key.group).isNotNull();
            Assertions.assertThat((int)key.orderInGroup).isGreaterThan(0);
            Assertions.assertThat((Object)key.validator).isNull();
            Assertions.assertThat((Object)key.recommender).isNull();
        });
    }

    protected abstract C getConnectorInstance();

    protected abstract Field.Set getAllFields();
}

