/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.binlog.AbstractBinlogConnectorIT;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.util.BinlogTestConnection;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.data.VerifyRecord;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class BinlogCustomSnapshotterIT<C extends SourceConnector>
extends AbstractBinlogConnectorIT<C> {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-connect.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE_CUSTOM_SNAPSHOT = TestHelper.getUniqueDatabase("myServer1", "custom_snapshot").withDbHistoryPath(SCHEMA_HISTORY_PATH);

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE_CUSTOM_SNAPSHOT.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    public void shouldAllowForCustomSnapshot() throws InterruptedException, SQLException {
        String pkField = "pk";
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE_CUSTOM_SNAPSHOT.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, BinlogConnectorConfig.SnapshotMode.CUSTOM.getValue())).with(BinlogConnectorConfig.SNAPSHOT_MODE_CUSTOM_NAME, this.getCustomSnapshotClassName())).with(CommonConnectorConfig.SNAPSHOT_QUERY_MODE, (EnumeratedValue)CommonConnectorConfig.SnapshotQueryMode.CUSTOM)).with(CommonConnectorConfig.SNAPSHOT_QUERY_MODE_CUSTOM_NAME, this.getCustomSnapshotClassName())).build();
        this.start(this.getConnectorClass(), config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords actualRecords = this.consumeRecordsByTopic(10);
        List s1recs = actualRecords.recordsForTopic(this.DATABASE_CUSTOM_SNAPSHOT.topicForTable("a"));
        List s2recs = actualRecords.recordsForTopic(this.DATABASE_CUSTOM_SNAPSHOT.topicForTable("b"));
        Assertions.assertThat((int)s1recs.size()).isEqualTo(1);
        Assertions.assertThat((List)s2recs).isNull();
        SourceRecord record = (SourceRecord)s1recs.get(0);
        VerifyRecord.isValidRead((SourceRecord)record, (String)"pk", (int)1);
        try (BinlogTestConnection db = this.getTestDatabaseConnection(this.DATABASE_CUSTOM_SNAPSHOT.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"INSERT INTO a (aa) VALUES (1);"});
            connection.execute(new String[]{"INSERT INTO b (aa) VALUES (1);"});
        }
        actualRecords = this.consumeRecordsByTopic(2);
        s1recs = actualRecords.recordsForTopic(this.DATABASE_CUSTOM_SNAPSHOT.topicForTable("a"));
        s2recs = actualRecords.recordsForTopic(this.DATABASE_CUSTOM_SNAPSHOT.topicForTable("b"));
        Assertions.assertThat((int)s1recs.size()).isEqualTo(1);
        Assertions.assertThat((int)s2recs.size()).isEqualTo(1);
        record = (SourceRecord)s1recs.get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"pk", (int)2);
        record = (SourceRecord)s2recs.get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"pk", (int)2);
        this.stopConnector();
        config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE_CUSTOM_SNAPSHOT.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, BinlogConnectorConfig.SnapshotMode.CUSTOM.getValue())).with(BinlogConnectorConfig.SNAPSHOT_MODE_CUSTOM_NAME, this.getCustomSnapshotClassName())).with(BinlogConnectorConfig.SNAPSHOT_QUERY_MODE, (EnumeratedValue)CommonConnectorConfig.SnapshotQueryMode.CUSTOM)).with(BinlogConnectorConfig.SNAPSHOT_QUERY_MODE_CUSTOM_NAME, this.getCustomSnapshotClassName())).build();
        this.start(this.getConnectorClass(), config);
        this.assertConnectorIsRunning();
        actualRecords = this.consumeRecordsByTopic(12);
        s1recs = actualRecords.recordsForTopic(this.DATABASE_CUSTOM_SNAPSHOT.topicForTable("a"));
        s2recs = actualRecords.recordsForTopic(this.DATABASE_CUSTOM_SNAPSHOT.topicForTable("b"));
        Assertions.assertThat((int)s1recs.size()).isEqualTo(2);
        Assertions.assertThat((int)s2recs.size()).isEqualTo(2);
        VerifyRecord.isValidRead((SourceRecord)((SourceRecord)s1recs.get(0)), (String)"pk", (int)1);
        VerifyRecord.isValidRead((SourceRecord)((SourceRecord)s1recs.get(1)), (String)"pk", (int)2);
        VerifyRecord.isValidRead((SourceRecord)((SourceRecord)s2recs.get(0)), (String)"pk", (int)1);
        VerifyRecord.isValidRead((SourceRecord)((SourceRecord)s2recs.get(1)), (String)"pk", (int)2);
    }

    protected abstract String getCustomSnapshotClassName();
}

