/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.Configuration;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogDatabaseSchema;
import io.debezium.connector.binlog.BinlogOffsetContext;
import io.debezium.connector.binlog.BinlogPartition;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.relational.history.TableChanges;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.text.ParsingException;
import io.debezium.util.IoUtil;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class BinlogDatabaseSchemaTest<C extends BinlogConnectorConfig, S extends BinlogDatabaseSchema<P, O, ?, ?>, P extends BinlogPartition, O extends BinlogOffsetContext<?>> {
    private static final Path TEST_FILE_PATH = Testing.Files.createTestingPath((String)"dbHistory.log");
    private final UniqueDatabase DATABASE = TestHelper.getUniqueDatabase("testServer", "connector_test", null, null).withDbHistoryPath(TEST_FILE_PATH);
    private static final String SERVER_NAME = "testServer";
    protected S schema;
    protected C connectorConfig;

    @Before
    public void beforeEach() {
        Testing.Files.delete((Path)TEST_FILE_PATH);
    }

    protected abstract C getConnectorConfig(Configuration var1);

    protected abstract S getSchema(Configuration var1);

    @After
    public void afterEach() {
        if (this.schema != null) {
            try {
                this.schema.close();
            }
            finally {
                this.schema = null;
            }
        }
    }

    @Test
    public void shouldApplyDdlStatementsAndRecover() throws InterruptedException {
        Configuration config = this.DATABASE.defaultConfig().build();
        this.schema = this.getSchema(config);
        this.schema.initializeStorage();
        P partition = this.initializePartition(this.connectorConfig, config);
        O offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.schema.parseStreamingDdl(partition, "SET character_set_server=utf8mb4", null, offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-products.ddl"), "db1", offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.close();
        this.assertTableIncluded("connector_test.products");
        this.assertTableIncluded("connector_test.products_on_hand");
        this.assertTableIncluded("connector_test.customers");
        this.assertTableIncluded("connector_test.orders");
        this.assertHistoryRecorded(config, partition, (OffsetContext)offset);
    }

    @Test
    public void shouldIgnoreUnparseableDdlAndRecover() throws InterruptedException {
        Configuration config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(SchemaHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, true)).build();
        this.schema = this.getSchema(config);
        this.schema.initializeStorage();
        P partition = this.initializePartition(this.connectorConfig, config);
        O offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.schema.parseStreamingDdl(partition, "SET character_set_server=utf8mb4", null, offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.parseStreamingDdl(partition, "xxxCREATE TABLE mytable\n" + IoUtil.readClassPathResource((String)"ddl/mysql-products.ddl"), "db1", offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-products.ddl"), "db1", offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.close();
        this.assertTableIncluded("connector_test.products");
        this.assertTableIncluded("connector_test.products_on_hand");
        this.assertTableIncluded("connector_test.customers");
        this.assertTableIncluded("connector_test.orders");
        this.assertHistoryRecorded(config, partition, (OffsetContext)offset);
    }

    @Test(expected=ParsingException.class)
    public void shouldFailOnUnparseableDdl() throws InterruptedException {
        Configuration config = this.DATABASE.defaultConfig().build();
        this.schema = this.getSchema(config);
        this.schema.initializeStorage();
        P partition = this.initializePartition(this.connectorConfig, config);
        O offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.schema.parseStreamingDdl(partition, "SET character_set_server=utf8mb4", null, offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.parseStreamingDdl(partition, "xxxCREATE TABLE mytable\n" + IoUtil.readClassPathResource((String)"ddl/mysql-products.ddl"), "db1", offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
    }

    @Test
    public void shouldLoadSystemAndNonSystemTablesAndConsumeOnlyFilteredDatabases() throws InterruptedException {
        Configuration config = ((Configuration.Builder)this.DATABASE.defaultConfigWithoutDatabaseFilter().with(SchemaHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, true)).build();
        this.schema = this.getSchema(config);
        this.schema.initializeStorage();
        P partition = this.initializePartition(this.connectorConfig, config);
        O offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.schema.parseStreamingDdl(partition, "SET character_set_server=utf8mb4", null, offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-test-init-5.7.ddl"), "mysql", offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        offset.setBinlogStartPoint("binlog.001", 1000L);
        this.schema.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-products.ddl"), "db1", offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.close();
        this.assertTableIncluded("connector_test.products");
        this.assertTableIncluded("connector_test.products_on_hand");
        this.assertTableIncluded("connector_test.customers");
        this.assertTableIncluded("connector_test.orders");
        this.assertTableExcluded("mysql.columns_priv");
        this.assertNoTablesExistForDatabase("mysql");
        this.assertHistoryRecorded(config, partition, (OffsetContext)offset);
    }

    @Test
    public void shouldLoadSystemAndNonSystemTablesAndConsumeAllDatabases() throws InterruptedException {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfigWithoutDatabaseFilter().with(SchemaHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, true)).with(BinlogConnectorConfig.TABLE_IGNORE_BUILTIN, false)).build();
        this.schema = this.getSchema(config);
        this.schema.initializeStorage();
        P partition = this.initializePartition(this.connectorConfig, config);
        O offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.schema.parseStreamingDdl(partition, "SET character_set_server=utf8mb4", null, offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-test-init-5.7.ddl"), "mysql", offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        offset.setBinlogStartPoint("binlog.001", 1000L);
        this.schema.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-products.ddl"), "db1", offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.close();
        this.assertTableIncluded("connector_test.products");
        this.assertTableIncluded("connector_test.products_on_hand");
        this.assertTableIncluded("connector_test.customers");
        this.assertTableIncluded("connector_test.orders");
        this.assertTableIncluded("mysql.columns_priv");
        this.assertTablesExistForDatabase("mysql");
        this.assertHistoryRecorded(config, partition, (OffsetContext)offset);
    }

    @Test
    public void shouldAllowDecimalPrecision() {
        Configuration config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(SchemaHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, false)).build();
        this.schema = this.getSchema(config);
        this.schema.initializeStorage();
        P partition = this.initializePartition(this.connectorConfig, config);
        O offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.schema.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-decimal-issue.ddl"), "db1", offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.close();
        this.assertTableIncluded("connector_test.business_order");
        this.assertTableIncluded("connector_test.business_order_detail");
        this.assertHistoryRecorded(config, partition, (OffsetContext)offset);
    }

    @Test
    @FixFor(value={"DBZ-3622"})
    public void shouldStoreNonCapturedDatabase() {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(SchemaHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, false)).with(BinlogConnectorConfig.DATABASE_INCLUDE_LIST, "captured")).build();
        this.schema = this.getSchema(config);
        this.schema.initializeStorage();
        P partition = this.initializePartition(this.connectorConfig, config);
        O offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.schema.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-schema-captured.ddl"), "db1", offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.close();
        this.assertTableIncluded("captured.ct");
        this.assertTableIncluded("captured.nct");
        this.assertTableExcluded("non_captured.nct");
        Configuration configFull = this.DATABASE.defaultConfigWithoutDatabaseFilter().build();
        this.schema = this.getSchema(configFull);
        this.schema.recover(Offsets.of(partition, offset));
        this.assertTableIncluded("captured.ct");
        this.assertTableIncluded("captured.nct");
        this.assertTableIncluded("non_captured.nct");
    }

    @Test
    @FixFor(value={"DBZ-3622"})
    public void shouldNotStoreNonCapturedDatabase() {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(SchemaHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, false)).with(BinlogConnectorConfig.DATABASE_INCLUDE_LIST, "captured")).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).build();
        this.schema = this.getSchema(config);
        this.schema.initializeStorage();
        P partition = this.initializePartition(this.connectorConfig, config);
        O offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.schema.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-schema-captured.ddl"), "db1", offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.close();
        this.assertTableIncluded("captured.ct");
        this.assertTableIncluded("captured.nct");
        this.assertTableExcluded("non_captured.nct");
        Configuration configFull = this.DATABASE.defaultConfigWithoutDatabaseFilter().build();
        this.schema = this.getSchema(configFull);
        this.schema.recover(Offsets.of(partition, offset));
        this.assertTableIncluded("captured.ct");
        this.assertTableIncluded("captured.nct");
        this.assertTableExcluded("non_captured.nct");
    }

    @Test
    @FixFor(value={"DBZ-3622"})
    public void shouldStoreNonCapturedTable() {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfigWithoutDatabaseFilter().with(SchemaHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, false)).with(BinlogConnectorConfig.TABLE_INCLUDE_LIST, "captured.ct")).build();
        this.schema = this.getSchema(config);
        this.schema.initializeStorage();
        P partition = this.initializePartition(this.connectorConfig, config);
        O offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.schema.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-schema-captured.ddl"), "db1", offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.close();
        this.assertTableIncluded("captured.ct");
        this.assertTableExcluded("captured.nct");
        this.assertTableExcluded("non_captured.nct");
        Configuration configFull = this.DATABASE.defaultConfigWithoutDatabaseFilter().build();
        this.schema = this.getSchema(configFull);
        this.schema.recover(Offsets.of(partition, offset));
        this.assertTableIncluded("captured.ct");
        this.assertTableIncluded("captured.nct");
        this.assertTableIncluded("non_captured.nct");
    }

    @Test
    @FixFor(value={"DBZ-3622"})
    public void shouldNotStoreNonCapturedTable() {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfigWithoutDatabaseFilter().with(SchemaHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, false)).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).with(BinlogConnectorConfig.TABLE_INCLUDE_LIST, "captured.ct")).build();
        this.schema = this.getSchema(config);
        this.schema.initializeStorage();
        P partition = this.initializePartition(this.connectorConfig, config);
        O offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.schema.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-schema-captured.ddl"), "db1", offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.close();
        this.assertTableIncluded("captured.ct");
        this.assertTableExcluded("captured.nct");
        this.assertTableExcluded("non_captured.nct");
        Configuration configFull = this.DATABASE.defaultConfigWithoutDatabaseFilter().build();
        this.schema = this.getSchema(configFull);
        this.schema.recover(Offsets.of(partition, offset));
        this.assertTableIncluded("captured.ct");
        this.assertTableExcluded("captured.nct");
        this.assertTableExcluded("non_captured.nct");
    }

    @Test
    public void addCommentToSchemaTest() {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(SchemaHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, false)).with(BinlogConnectorConfig.DATABASE_INCLUDE_LIST, "captured")).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).with(BinlogConnectorConfig.INCLUDE_SCHEMA_COMMENTS, true)).build();
        this.schema = this.getSchema(config);
        this.schema.initializeStorage();
        P partition = this.initializePartition(this.connectorConfig, config);
        O offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.schema.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-schema-captured.ddl"), "db1", offset, Instant.now()).forEach(x -> this.schema.applySchemaChange(x));
        this.schema.close();
        this.assertTableSchemaComments("captured.ct", "id", null);
        this.assertTableSchemaComments("captured.ct", "code", "order code");
    }

    @Test
    @FixFor(value={"DBZ-6945"})
    public void shouldProduceCorrectTableChangesForDropStatement() {
        Configuration config = this.DATABASE.defaultConfig().build();
        this.schema = this.getSchema(config);
        this.schema.initializeStorage();
        P partition = this.initializePartition(this.connectorConfig, config);
        O offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        List schemaChangeEvents = this.schema.parseStreamingDdl(partition, "DROP TABLE IF EXISTS connector_test.products", "db1", offset, Instant.now());
        this.schema.close();
        Assertions.assertThat((int)schemaChangeEvents.size()).isEqualTo(1);
        TableChanges.TableChange tableChange = (TableChanges.TableChange)((SchemaChangeEvent)schemaChangeEvents.get(0)).getTableChanges().iterator().next();
        Assertions.assertThat((Object)tableChange.getTable()).isEqualTo(null);
        Assertions.assertThat((Comparable)tableChange.getType()).isEqualTo((Object)TableChanges.TableChangeType.DROP);
        Assertions.assertThat((Comparable)tableChange.getId()).isEqualTo((Object)TableId.parse((String)"connector_test.products"));
    }

    protected void assertTableSchemaComments(String tableName, String column, String comments) {
        TableId tableId = TableId.parse((String)tableName);
        TableSchema tableSchema = this.schema.schemaFor(tableId);
        Schema valueSchema = tableSchema.valueSchema();
        Field columnField = valueSchema.field(column);
        Assertions.assertThat((String)columnField.schema().doc()).isEqualTo((Object)comments);
    }

    protected void assertTableIncluded(String fullyQualifiedTableName) {
        TableId tableId = TableId.parse((String)fullyQualifiedTableName);
        TableSchema tableSchema = this.schema.schemaFor(tableId);
        Assertions.assertThat((Object)tableSchema).isNotNull();
        Assertions.assertThat((String)tableSchema.keySchema().name()).isEqualTo((Object)SchemaNameAdjuster.validFullname((String)("testServer." + fullyQualifiedTableName + ".Key")));
        Assertions.assertThat((String)tableSchema.valueSchema().name()).isEqualTo((Object)SchemaNameAdjuster.validFullname((String)("testServer." + fullyQualifiedTableName + ".Value")));
    }

    protected void assertTableExcluded(String fullyQualifiedTableName) {
        TableId tableId = TableId.parse((String)fullyQualifiedTableName);
        Assertions.assertThat((Object)this.schema.schemaFor(tableId)).isNull();
    }

    protected void assertNoTablesExistForDatabase(String dbName) {
        Assertions.assertThat((long)this.schema.tableIds().stream().filter(id -> id.catalog().equals(dbName)).count()).isEqualTo(0L);
    }

    protected void assertTablesExistForDatabase(String dbName) {
        Assertions.assertThat((long)this.schema.tableIds().stream().filter(id -> id.catalog().equals(dbName)).count()).isGreaterThan(0L);
    }

    protected void assertHistoryRecorded(Configuration config, P partition, OffsetContext offset) {
        try (S duplicate = this.getSchema(config);){
            duplicate.recover(Offsets.of(partition, (OffsetContext)offset));
            Assertions.assertThat((Iterable)duplicate.tableIds()).isEqualTo((Object)this.schema.tableIds());
            for (int i = 0; i != 2; ++i) {
                duplicate.tableIds().forEach(tableId -> {
                    TableSchema dupSchema = duplicate.schemaFor(tableId);
                    TableSchema tableSchema = this.schema.schemaFor(tableId);
                    Assertions.assertThat((Object)tableSchema).isEqualTo((Object)dupSchema);
                    Table dupTable = duplicate.tableFor(tableId);
                    Table table = this.schema.tableFor(tableId);
                    Assertions.assertThat((Object)table).isEqualTo((Object)dupTable);
                });
                this.schema.tableIds().forEach(tableId -> {
                    TableSchema dupSchema = duplicate.schemaFor(tableId);
                    TableSchema tableSchema = this.schema.schemaFor(tableId);
                    Assertions.assertThat((Object)tableSchema).isEqualTo((Object)dupSchema);
                    Table dupTable = duplicate.tableFor(tableId);
                    Table table = this.schema.tableFor(tableId);
                    Assertions.assertThat((Object)table).isEqualTo((Object)dupTable);
                });
                duplicate.refreshSchemas();
            }
        }
    }

    protected void printStatements(String dbName, Set<TableId> tables, String ddlStatements) {
        Testing.print((Object)("Running DDL for '" + dbName + "': " + ddlStatements + " changing tables '" + String.valueOf(tables) + "'"));
    }

    protected abstract P initializePartition(C var1, Configuration var2);

    protected abstract O initializeOffset(C var1);
}

