/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.binlog.AbstractBinlogConnectorIT;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.junit.SkipTestDependingOnDatabaseRule;
import io.debezium.connector.binlog.junit.SkipWhenDatabaseIs;
import io.debezium.connector.binlog.util.BinlogTestConnection;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.history.MemorySchemaHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceConnector;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenDatabaseIs(value=SkipWhenDatabaseIs.Type.MARIADB, reason="Visible columns not supported")
public abstract class BinlogDdlParserIT<C extends SourceConnector>
extends AbstractBinlogConnectorIT<C> {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-ddl-parser.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = TestHelper.getUniqueDatabase("myServer1", "binlog_ddl_parser").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    @Rule
    public TestRule skipRule = new SkipTestDependingOnDatabaseRule();

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    protected Configuration.Builder defaultConfig() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.INITIAL)).with(BinlogConnectorConfig.SCHEMA_HISTORY, MemorySchemaHistory.class.getName())).with(BinlogConnectorConfig.BUFFER_SIZE_FOR_BINLOG_READER, 10000);
    }

    @Test
    public void parseTableWithVisibleColumns() throws Exception {
        try (BinlogTestConnection db = this.getTestDatabaseConnection(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"SELECT VERSION();"});
            connection.execute(new String[]{"CREATE TABLE VISIBLE_COLUMN_TABLE (    ID BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY,    NAME VARCHAR(100) NOT NULL,    WORK_ID BIGINT VISIBLE);"});
            connection.execute(new String[]{"INSERT INTO VISIBLE_COLUMN_TABLE VALUES (1001,'Larry',113);"});
        }
        this.start(this.getConnectorClass(), this.defaultConfig().build());
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(30);
        boolean statementFound = records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).stream().anyMatch(s -> ((Struct)s.value()).getString("ddl").equals("CREATE TABLE `VISIBLE_COLUMN_TABLE` (\n  `ID` bigint NOT NULL AUTO_INCREMENT,\n  `NAME` varchar(100) NOT NULL,\n  `WORK_ID` bigint DEFAULT NULL,\n  PRIMARY KEY (`ID`)\n) ENGINE=InnoDB AUTO_INCREMENT=1002 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci"));
        Assertions.assertThat((boolean)statementFound).isTrue();
    }

    @Test
    public void parseTableWithInVisibleColumns() throws Exception {
        try (BinlogTestConnection db = this.getTestDatabaseConnection(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"SELECT VERSION();"});
            connection.execute(new String[]{"CREATE TABLE INVISIBLE_COLUMN_TABLE ( ID BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY, NAME VARCHAR(100) NOT NULL, WORK_ID BIGINT INVISIBLE);"});
            connection.execute(new String[]{"INSERT INTO INVISIBLE_COLUMN_TABLE VALUES (1002,'Jack');"});
        }
        this.start(this.getConnectorClass(), this.defaultConfig().build());
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(30);
        boolean statementFound = records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).stream().anyMatch(s -> ((Struct)s.value()).getString("ddl").equals("CREATE TABLE `INVISIBLE_COLUMN_TABLE` (\n  `ID` bigint NOT NULL AUTO_INCREMENT,\n  `NAME` varchar(100) NOT NULL,\n  `WORK_ID` bigint DEFAULT NULL /*!80023 INVISIBLE */,\n  PRIMARY KEY (`ID`)\n) ENGINE=InnoDB AUTO_INCREMENT=1003 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci"));
        Assertions.assertThat((boolean)statementFound).isTrue();
    }

    @Test
    public void parseTableCreatedWithTableStatement() throws Exception {
        try (BinlogTestConnection db = this.getTestDatabaseConnection(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"CREATE TABLE table1 (ID BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY,NAME VARCHAR(100) NOT NULL);"});
            connection.execute(new String[]{"CREATE TABLE table2 (WORK_ID BIGINT) TABLE table1;"});
            connection.execute(new String[]{"INSERT INTO table2 VALUES (113, 1001,'Larry');"});
        }
        this.start(this.getConnectorClass(), this.defaultConfig().build());
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(30);
        boolean statementFound = records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).stream().anyMatch(s -> ((Struct)s.value()).getString("ddl").equals("CREATE TABLE `table2` (\n  `WORK_ID` bigint DEFAULT NULL,\n  `ID` bigint NOT NULL DEFAULT '0',\n  `NAME` varchar(100) NOT NULL\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci"));
        Assertions.assertThat((boolean)statementFound).isTrue();
    }
}

