/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.binlog.AbstractBinlogConnectorIT;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.util.BinlogTestConnection;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class BinlogDefaultDatabaseCharsetIT<C extends SourceConnector>
extends AbstractBinlogConnectorIT<C> {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-connect.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = TestHelper.getUniqueDatabase("myServer1", "db_default_charset", "utf8mb4").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    public void databaseWithDefaultCharsetTest() throws InterruptedException, SQLException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.INITIAL)).with(BinlogConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("DATA") + "," + this.DATABASE.qualifiedTableName("DATASTREAM"))).build();
        this.start(this.getConnectorClass(), this.config);
        Testing.Print.enable();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(7);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("DATA")).get(0);
        Assertions.assertThat((String)((Struct)record.value()).getStruct("after").getString("MESSAGE")).isEqualTo((Object)"\u017dlu\u0165ou\u010dk\u00fd");
        try (BinlogTestConnection db = this.getTestDatabaseConnection(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"CREATE TABLE DATASTREAM (MESSAGE TEXT);"});
            connection.execute(new String[]{"INSERT INTO DATASTREAM VALUES ('\u017dlu\u0165ou\u010dk\u00fd');"});
        }
        records = this.consumeRecordsByTopic(2);
        SourceRecord recordStream = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("DATASTREAM")).get(0);
        Assertions.assertThat((String)((Struct)recordStream.value()).getStruct("after").getString("MESSAGE")).isEqualTo((Object)"\u017dlu\u0165ou\u010dk\u00fd");
    }
}

