/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.util.BinlogTestConnection;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.pipeline.AbstractMetricsTest;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.storage.file.history.FileSchemaHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.kafka.connect.source.SourceConnector;
import org.junit.After;
import org.junit.Before;

public abstract class BinlogMetricsIT<C extends SourceConnector>
extends AbstractMetricsTest<C> {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-metrics.txt").toAbsolutePath();
    private static final String SERVER_NAME = "myserver";
    private final UniqueDatabase DATABASE = TestHelper.getUniqueDatabase("myserver", "connector_metrics_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private static final String INSERT1 = "INSERT INTO simple (val) VALUES (25);";
    private static final String INSERT2 = "INSERT INTO simple (val) VALUES (50);";

    protected abstract String getConnectorName();

    protected abstract BinlogTestConnection getTestDatabaseConnection(String var1);

    protected String connector() {
        return this.getConnectorName();
    }

    protected String server() {
        return SERVER_NAME;
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.INITIAL)).with(BinlogConnectorConfig.SCHEMA_HISTORY, FileSchemaHistory.class)).with(FileSchemaHistory.FILE_PATH, (Object)SCHEMA_HISTORY_PATH)).with(BinlogConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("simple"))).with(BinlogConnectorConfig.TABLES_IGNORE_BUILTIN, (Object)Boolean.TRUE)).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, (Object)Boolean.TRUE);
    }

    protected Configuration.Builder noSnapshot(Configuration.Builder config) {
        return (Configuration.Builder)config.with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.NO_DATA);
    }

    protected void executeInsertStatements() throws SQLException {
        try (Connection connection = this.getTestDatabaseConnection(this.DATABASE.getDatabaseName()).connection();){
            connection.createStatement().execute(INSERT1);
            connection.createStatement().execute(INSERT2);
        }
    }

    protected String tableName() {
        return this.DATABASE.qualifiedTableName("simple");
    }

    protected long expectedEvents() {
        return 2L;
    }

    protected boolean snapshotCompleted() {
        return true;
    }

    @Before
    public void before() throws Exception {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws Exception {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    protected ObjectName getSnapshotMetricsObjectName() throws MalformedObjectNameException {
        return BinlogMetricsIT.getSnapshotMetricsObjectName((String)this.getConnectorName(), (String)SERVER_NAME);
    }

    public ObjectName getStreamingMetricsObjectName() throws MalformedObjectNameException {
        return BinlogMetricsIT.getStreamingMetricsObjectName((String)this.getConnectorName(), (String)SERVER_NAME, (String)BinlogMetricsIT.getStreamingNamespace());
    }
}

