/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import ch.qos.logback.classic.Level;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogSnapshotChangeEventSource;
import io.debezium.connector.binlog.BinlogSnapshotSourceIT;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.ConditionalFail;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.Flaky;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.util.Collect;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceConnector;
import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenDatabaseVersion(check=EqualityCheck.LESS_THAN, major=5, minor=6, reason="DDL uses fractional second data types, not supported until MySQL 5.6")
public abstract class BinlogSnapshotParallelSourceIT<C extends SourceConnector>
extends BinlogSnapshotSourceIT<C> {
    @Rule
    public TestRule conditionalFail = new ConditionalFail();

    @Override
    protected Configuration.Builder simpleConfig() {
        return (Configuration.Builder)super.simpleConfig().with(BinlogConnectorConfig.SNAPSHOT_MAX_THREADS, 3);
    }

    @Override
    @Ignore
    @Test
    public void shouldSnapshotTablesInRowCountOrderAsc() {
    }

    @Override
    @Ignore
    @Test
    public void shouldSnapshotTablesInRowCountOrderDesc() {
    }

    @Override
    @Ignore
    @Test
    public void shouldSnapshotTablesInLexicographicalOrder() {
    }

    @Override
    @Ignore
    @Test
    public void shouldSnapshotTablesInOrderSpecifiedInTableIncludeList() {
    }

    @Override
    @Ignore
    @Test
    public void shouldSnapshotTablesInOrderSpecifiedInTableIncludeListWithConflictingNames() {
    }

    @Override
    @Test
    @Flaky(value="DBZ-7472")
    public void shouldCreateSnapshotOfSingleDatabaseWithoutGlobalLock() throws Exception {
        super.shouldCreateSnapshotOfSingleDatabaseWithoutGlobalLock();
    }

    @Test
    public void shouldParallelCreateSnapshotSchema() throws Exception {
        List includeDatabases = Collect.arrayListOf((Object)this.DATABASE.getDatabaseName(), (Object[])new String[]{this.OTHER_DATABASE.getDatabaseName()});
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.simpleConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.NO_DATA)).with(BinlogConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(this.getSnapshotLockingModeField(), this.getSnapshotLockingModeNone())).with(BinlogConnectorConfig.DATABASE_INCLUDE_LIST, String.join((CharSequence)",", includeDatabases))).build();
        LogInterceptor logInterceptor = new LogInterceptor(BinlogSnapshotChangeEventSource.class);
        logInterceptor.setLoggerLevel(BinlogSnapshotChangeEventSource.class, Level.INFO);
        this.start(this.getConnectorClass(), this.config);
        BinlogSnapshotParallelSourceIT.waitForSnapshotToBeCompleted((String)this.getConnectorName(), (String)this.DATABASE.getServerName());
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(100);
        List schemaRecords = sourceRecords.recordsForTopic(this.DATABASE.getServerName());
        List sourceDatabases = schemaRecords.stream().map(record -> ((Struct)record.value()).get("databaseName").toString()).filter(includeDatabases::contains).distinct().collect(Collectors.toList());
        Assertions.assertThat((int)sourceDatabases.size()).isEqualTo(2);
        Assertions.assertThat((boolean)logInterceptor.containsMessage("Creating schema snapshot worker pool with 3 worker thread(s)")).isTrue();
    }
}

