/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.binlog.AbstractBinlogConnectorIT;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.util.BinlogTestConnection;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@SkipWhenDatabaseVersion(check=EqualityCheck.LESS_THAN, major=9, minor=0, reason="VECTOR datatype not added until MySQL 9.0")
public abstract class BinlogVectorIT<C extends SourceConnector>
extends AbstractBinlogConnectorIT<C> {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-json.txt").toAbsolutePath();
    private UniqueDatabase DATABASE;
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE = TestHelper.getUniqueDatabase("vectorit", "vector_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingSnapshot() throws SQLException, InterruptedException {
        this.config = this.DATABASE.defaultConfig().build();
        this.start(this.getConnectorClass(), this.config);
        int numTables = 1;
        int numDataRecords = 1;
        int numDdlRecords = numTables * 2 + 3;
        int numSetVariables = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numDdlRecords + numSetVariables + numDataRecords);
        Assertions.assertThat((Object)records).isNotNull();
        List dataRecords = records.recordsForTopic(this.DATABASE.topicForTable("dbz_8157"));
        Assertions.assertThat((List)dataRecords).hasSize(1);
        SourceRecord record = (SourceRecord)dataRecords.get(0);
        Struct after = ((Struct)record.value()).getStruct("after");
        Assertions.assertThat((String)after.schema().field("f_vector_null").schema().name()).isEqualTo((Object)"io.debezium.data.FloatVector");
        Assertions.assertThat((List)after.getArray("f_vector_null")).containsExactly(new Object[]{Float.valueOf(1.1f), Float.valueOf(2.2f)});
        Assertions.assertThat((List)after.getArray("f_vector_default")).containsExactly(new Object[]{Float.valueOf(11.5f), Float.valueOf(22.6f)});
        Assertions.assertThat((List)after.getArray("f_vector_cons")).containsExactly(new Object[]{Float.valueOf(31.0f), Float.valueOf(32.0f)});
        this.stopConnector();
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingStreaming() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.NO_DATA)).build();
        this.start(this.getConnectorClass(), this.config);
        int numTables = 1;
        int numDdlRecords = numTables * 2 + 3;
        int numSetVariables = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numDdlRecords + numSetVariables);
        try (BinlogTestConnection db = this.getTestDatabaseConnection(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"INSERT INTO dbz_8157 VALUES (default, string_to_vector('[10.1,10.2]'),string_to_vector('[20.1,20.2]'),string_to_vector('[30.1,30.2]'));"});
        }
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((Object)records).isNotNull();
        List dataRecords = records.recordsForTopic(this.DATABASE.topicForTable("dbz_8157"));
        Assertions.assertThat((List)dataRecords).hasSize(1);
        SourceRecord record = (SourceRecord)dataRecords.get(0);
        Struct after = ((Struct)record.value()).getStruct("after");
        Assertions.assertThat((String)after.schema().field("f_vector_null").schema().name()).isEqualTo((Object)"io.debezium.data.FloatVector");
        Assertions.assertThat((List)after.getArray("f_vector_null")).containsExactly(new Object[]{Float.valueOf(10.1f), Float.valueOf(10.2f)});
        Assertions.assertThat((List)after.getArray("f_vector_default")).containsExactly(new Object[]{Float.valueOf(20.1f), Float.valueOf(20.2f)});
        Assertions.assertThat((List)after.getArray("f_vector_cons")).containsExactly(new Object[]{Float.valueOf(30.1f), Float.valueOf(30.2f)});
        this.stopConnector();
    }
}

