/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.binlog.AbstractBinlogConnectorIT;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class BinlogYearIT<C extends SourceConnector>
extends AbstractBinlogConnectorIT<C> {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-year.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = TestHelper.getUniqueDatabase("yearit", "year_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-1143"})
    public void shouldProcessTwoAndForDigitYearsInDatabase() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.INITIAL)).with(BinlogConnectorConfig.ENABLE_TIME_ADJUSTER, false)).build();
        this.start(this.getConnectorClass(), this.config);
        int numDatabase = 2;
        int numTables = 2;
        int numOthers = 2;
        this.consumeRecords(6);
        this.assertChangeRecordByDatabase();
        try (Connection conn = this.getTestDatabaseConnection(this.DATABASE.getDatabaseName()).connection();){
            conn.createStatement().execute("INSERT INTO dbz_1143_year_test VALUES (\n    default,\n    '18',\n    '0018',\n    '2018',\n    '18-04-01',\n    '0018-04-01',\n    '2018-04-01',\n    '18-04-01 12:34:56',\n    '0018-04-01 12:34:56',\n    '2018-04-01 12:34:56',\n    '78',\n    '0078',\n    '1978',\n    '78-04-01',\n    '0078-04-01',\n    '1978-04-01',\n    '78-04-01 12:34:56',\n    '0078-04-01 12:34:56',\n    '1978-04-01 12:34:56');");
        }
        this.assertChangeRecordByDatabase();
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-1143"})
    public void shouldProcessTwoAndForDigitYearsInConnector() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(this.getConnectorClass(), this.config);
        int numDatabase = 2;
        int numTables = 2;
        int numOthers = 2;
        this.consumeRecords(6);
        this.assertChangeRecordByConnector();
        try (Connection conn = this.getTestDatabaseConnection(this.DATABASE.getDatabaseName()).connection();){
            conn.createStatement().execute("INSERT INTO dbz_1143_year_test VALUES (\n    default,\n    '18',\n    '0018',\n    '2018',\n    '18-04-01',\n    '0018-04-01',\n    '2018-04-01',\n    '18-04-01 12:34:56',\n    '0018-04-01 12:34:56',\n    '2018-04-01 12:34:56',\n    '78',\n    '0078',\n    '1978',\n    '78-04-01',\n    '0078-04-01',\n    '1978-04-01',\n    '78-04-01 12:34:56',\n    '0078-04-01 12:34:56',\n    '1978-04-01 12:34:56');");
        }
        this.assertChangeRecordByConnector();
        this.stopConnector();
    }

    private void assertChangeRecordByDatabase() throws InterruptedException {
        SourceRecord record = this.consumeRecord();
        Assertions.assertThat((Object)record).isNotNull();
        Struct change = ((Struct)record.value()).getStruct("after");
        Assertions.assertThat((Integer)change.getInt32("y18")).isEqualTo(2018);
        Assertions.assertThat((Integer)change.getInt32("y0018")).isEqualTo(2018);
        Assertions.assertThat((Integer)change.getInt32("y2018")).isEqualTo(2018);
        Assertions.assertThat((Integer)change.getInt32("d18")).isEqualTo(17622);
        Assertions.assertThat((Integer)change.getInt32("d0018")).isEqualTo(-712863);
        Assertions.assertThat((Integer)change.getInt32("d2018")).isEqualTo(17622);
        Assertions.assertThat((Long)change.getInt64("dt18")).isEqualTo(1522586096000L);
        Assertions.assertThat((Long)change.getInt64("dt2018")).isEqualTo(1522586096000L);
        Assertions.assertThat((Integer)change.getInt32("y78")).isEqualTo(1978);
        Assertions.assertThat((Integer)change.getInt32("y0078")).isEqualTo(1978);
        Assertions.assertThat((Integer)change.getInt32("y1978")).isEqualTo(1978);
        Assertions.assertThat((Integer)change.getInt32("d78")).isEqualTo(3012);
        Assertions.assertThat((Integer)change.getInt32("d0078")).isEqualTo(-690948);
        Assertions.assertThat((Integer)change.getInt32("d1978")).isEqualTo(3012);
        Assertions.assertThat((Long)change.getInt64("dt78")).isEqualTo(260282096000L);
        Assertions.assertThat((Long)change.getInt64("dt1978")).isEqualTo(260282096000L);
    }

    private void assertChangeRecordByConnector() throws InterruptedException {
        SourceRecord record = this.consumeRecord();
        Assertions.assertThat((Object)record).isNotNull();
        Struct change = ((Struct)record.value()).getStruct("after");
        Assertions.assertThat((Integer)change.getInt32("y18")).isEqualTo(2018);
        Assertions.assertThat((Integer)change.getInt32("y0018")).isEqualTo(2018);
        Assertions.assertThat((Integer)change.getInt32("y2018")).isEqualTo(2018);
        Assertions.assertThat((Integer)change.getInt32("d18")).isEqualTo(17622);
        Assertions.assertThat((Integer)change.getInt32("d0018")).isEqualTo(17622);
        Assertions.assertThat((Integer)change.getInt32("d2018")).isEqualTo(17622);
        Assertions.assertThat((Long)change.getInt64("dt18")).isEqualTo(1522586096000L);
        Assertions.assertThat((Long)change.getInt64("dt0018")).isEqualTo(1522586096000L);
        Assertions.assertThat((Long)change.getInt64("dt2018")).isEqualTo(1522586096000L);
        Assertions.assertThat((Integer)change.getInt32("y78")).isEqualTo(1978);
        Assertions.assertThat((Integer)change.getInt32("y0078")).isEqualTo(1978);
        Assertions.assertThat((Integer)change.getInt32("y1978")).isEqualTo(1978);
        Assertions.assertThat((Integer)change.getInt32("d78")).isEqualTo(3012);
        Assertions.assertThat((Integer)change.getInt32("d0078")).isEqualTo(3012);
        Assertions.assertThat((Integer)change.getInt32("d1978")).isEqualTo(3012);
        Assertions.assertThat((Long)change.getInt64("dt78")).isEqualTo(260282096000L);
        Assertions.assertThat((Long)change.getInt64("dt0078")).isEqualTo(260282096000L);
        Assertions.assertThat((Long)change.getInt64("dt1978")).isEqualTo(260282096000L);
    }
}

