/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog.zzz;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.binlog.AbstractBinlogConnectorIT;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.junit.SkipTestDependingOnDatabaseRule;
import io.debezium.connector.binlog.junit.SkipTestDependingOnGtidModeRule;
import io.debezium.connector.binlog.junit.SkipWhenDatabaseIs;
import io.debezium.connector.binlog.junit.SkipWhenGtidModeIs;
import io.debezium.connector.binlog.util.BinlogTestConnection;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenDatabaseVersion(check=EqualityCheck.LESS_THAN, major=5, minor=6, reason="DDL uses fractional second data types, not supported until MySQL 5.6")
@SkipWhenDatabaseIs(value=SkipWhenDatabaseIs.Type.MARIADB, reason="MariaDB does not support purged GTID sets")
@SkipWhenGtidModeIs(value=SkipWhenGtidModeIs.GtidMode.OFF)
public abstract class ZZZBinlogGtidSetIT<C extends SourceConnector>
extends AbstractBinlogConnectorIT<C> {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-connect.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = TestHelper.getUniqueDatabase("myServer1", "connector_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private final UniqueDatabase RO_DATABASE = TestHelper.getUniqueDatabase("myServer2", "connector_test_ro", this.DATABASE).withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;
    @Rule
    public TestRule skipTest = new SkipTestDependingOnGtidModeRule();
    @Rule
    public TestRule skipTest2 = new SkipTestDependingOnDatabaseRule();

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.RO_DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    private boolean isGtidModeEnabled() throws SQLException {
        try (BinlogTestConnection db = this.getTestDatabaseConnection(this.DATABASE.getDatabaseName());){
            boolean bl = db.isGtidEnabled();
            return bl;
        }
    }

    @Test
    @FixFor(value={"DBZ-1184"})
    public void shouldProcessPurgedGtidSet() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        this.purgeDatabaseLogs();
        UniqueDatabase database = TestHelper.getUniqueDatabase("myServer1", "connector_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
        UniqueDatabase ro_database = TestHelper.getUniqueDatabase("myServer2", "connector_test_ro", database).withDbHistoryPath(SCHEMA_HISTORY_PATH);
        ro_database.createAndInitialize();
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)ro_database.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.NEVER)).with(BinlogConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(BinlogConnectorConfig.TABLE_INCLUDE_LIST, ro_database.qualifiedTableName("customers"))).build();
        this.start(this.getConnectorClass(), this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((int)records.recordsForTopic(ro_database.topicForTable("customers")).size()).isEqualTo(4);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(ro_database.getDatabaseName()).size()).isEqualTo(6);
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
        records.recordsForTopic(ro_database.topicForTable("customers")).forEach(record -> {
            String gtids = (String)record.sourceOffset().get("gtids");
            Pattern p = Pattern.compile(".*:(.*)-.*");
            Matcher m = p.matcher(gtids);
            m.matches();
            Assertions.assertThat((String)m.group(1)).isNotEqualTo((Object)"1");
        });
        this.stopConnector();
    }

    private void purgeDatabaseLogs() throws SQLException {
        try (BinlogTestConnection db = this.getTestDatabaseConnection(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"FLUSH LOGS"});
            List<String> binlogs = this.getBinlogs(connection);
            String lastBinlogName = binlogs.get(binlogs.size() - 1);
            connection.execute(new String[]{"PURGE BINARY LOGS TO '" + lastBinlogName + "'"});
            Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> {
                List<String> binlogsAfterPurge = this.getBinlogs(connection);
                if (binlogsAfterPurge.size() != 1) {
                    Testing.print((Object)("Binlogs before purging: " + String.valueOf(binlogs)));
                    Testing.print((Object)("Binlogs after purging: " + String.valueOf(binlogsAfterPurge)));
                }
                return binlogsAfterPurge.size() == 1;
            });
        }
    }

    private List<String> getBinlogs(JdbcConnection connection) throws SQLException {
        return (List)connection.queryAndMap("SHOW BINARY LOGS", rs -> {
            ArrayList<String> binlogs = new ArrayList<String>();
            while (rs.next()) {
                binlogs.add(rs.getString(1));
            }
            return binlogs;
        });
    }

    @Test
    @FixFor(value={"DBZ-1244"})
    public void shouldProcessPurgedLogsWhenDownAndSnapshotNeeded() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        this.purgeDatabaseLogs();
        UniqueDatabase database = TestHelper.getUniqueDatabase("myServer1", "connector_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
        database.createAndInitialize();
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)database.defaultConfig().with(BinlogConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)BinlogConnectorConfig.SnapshotMode.WHEN_NEEDED)).with(BinlogConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(BinlogConnectorConfig.TABLE_INCLUDE_LIST, database.qualifiedTableName("customers"))).build();
        this.start(this.getConnectorClass(), this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(16);
        Assertions.assertThat((int)records.recordsForTopic(database.topicForTable("customers")).size()).isEqualTo(4);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(database.getDatabaseName()).size()).isEqualTo(11);
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
        this.stopConnector();
        try (BinlogTestConnection db = this.getTestDatabaseConnection(database.getDatabaseName());){
            db.execute(new String[]{"INSERT INTO customers VALUES(default,1,1,1)", "INSERT INTO customers VALUES(default,2,2,2)"});
        }
        this.start(this.getConnectorClass(), this.config);
        records = this.consumeRecordsByTopic(2);
        this.stopConnector();
        db = this.getTestDatabaseConnection(database.getDatabaseName());
        try {
            db.execute(new String[]{"INSERT INTO customers VALUES(default,3,3,3)", "INSERT INTO customers VALUES(default,4,4,4)"});
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        this.purgeDatabaseLogs();
        this.start(this.getConnectorClass(), this.config);
        records = this.consumeRecordsByTopic(20);
        Assertions.assertThat((int)records.recordsForTopic(database.topicForTable("customers")).size()).isEqualTo(8);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(database.getDatabaseName()).size()).isEqualTo(11);
        this.stopConnector();
        db = this.getTestDatabaseConnection(database.getDatabaseName());
        try {
            db.execute(new String[]{"INSERT INTO customers VALUES(default,5,5,5)", "INSERT INTO customers VALUES(default,6,6,6)"});
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        this.purgeDatabaseLogs();
        db = this.getTestDatabaseConnection(database.getDatabaseName());
        try {
            db.execute(new String[]{"INSERT INTO customers VALUES(default,7,7,7)", "INSERT INTO customers VALUES(default,8,8,8)"});
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        this.start(this.getConnectorClass(), this.config);
        records = this.consumeRecordsByTopic(24);
        Assertions.assertThat((int)records.recordsForTopic(database.topicForTable("customers")).size()).isEqualTo(12);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(database.getDatabaseName()).size()).isEqualTo(11);
        this.stopConnector();
    }
}

