/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog.jdbc;

import io.debezium.config.Configuration;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.jdbc.ConnectionConfiguration;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Strings;
import java.time.Duration;
import java.util.Objects;

public abstract class BinlogConnectionConfiguration
implements ConnectionConfiguration {
    private final JdbcConfiguration jdbcConfig;
    private final JdbcConnection.ConnectionFactory factory;
    private final Configuration configuration;

    public BinlogConnectionConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.jdbcConfig = this.getJdbcConfiguration(this.getDatabaseConfiguration(configuration).build().subset("database.", true).merge(new Configuration[]{configuration.subset("driver.", true)}));
        this.factory = this.createFactory(configuration);
    }

    @Override
    public JdbcConfiguration config() {
        return this.jdbcConfig;
    }

    @Override
    public Configuration originalConfig() {
        return this.configuration;
    }

    @Override
    public JdbcConnection.ConnectionFactory factory() {
        return this.factory;
    }

    @Override
    public String username() {
        return this.configuration.getString(BinlogConnectorConfig.USER);
    }

    @Override
    public String password() {
        return this.configuration.getString(BinlogConnectorConfig.PASSWORD);
    }

    @Override
    public String hostname() {
        return this.configuration.getString(BinlogConnectorConfig.HOSTNAME);
    }

    @Override
    public int port() {
        return this.configuration.getInteger(BinlogConnectorConfig.PORT);
    }

    @Override
    public String sslKeyStore() {
        return this.configuration.getString(BinlogConnectorConfig.SSL_KEYSTORE);
    }

    @Override
    public char[] sslKeyStorePassword() {
        String password = this.configuration.getString(BinlogConnectorConfig.SSL_KEYSTORE_PASSWORD);
        return Strings.isNullOrBlank((String)password) ? null : password.toCharArray();
    }

    @Override
    public String sslTrustStore() {
        return this.configuration.getString(BinlogConnectorConfig.SSL_TRUSTSTORE);
    }

    @Override
    public char[] sslTrustStorePassword() {
        String password = this.configuration.getString(BinlogConnectorConfig.SSL_TRUSTSTORE_PASSWORD);
        return Strings.isNullOrBlank((String)password) ? null : password.toCharArray();
    }

    @Override
    public abstract String getUrlPattern();

    protected Configuration.Builder getDatabaseConfiguration(Configuration configuration) {
        return (Configuration.Builder)configuration.edit().withDefault(BinlogConnectorConfig.PORT, BinlogConnectorConfig.PORT.defaultValue());
    }

    protected JdbcConfiguration getJdbcConfiguration(Configuration configuration) {
        Configuration.Builder builder = configuration.edit().with("connectTimeout", Long.toString(this.getConnectionTimeout(configuration).toMillis())).with("sslMode", this.sslMode().getValue()).with(this.getConnectionTimeZonePropertyName(), this.resolveConnectionTimeZone(configuration)).with("allowLoadLocalInfile", Boolean.FALSE.toString()).with("allowUrlInLocalInfile", Boolean.FALSE.toString()).with("autoDeserialize", Boolean.FALSE.toString()).without("queryInterceptors");
        if (this.sslModeEnabled()) {
            if (!Strings.isNullOrBlank((String)this.sslTrustStore())) {
                builder.with("trustCertificateKeyStoreUrl", "file:" + this.sslTrustStore());
            }
            if (!Objects.isNull(this.sslTrustStorePassword())) {
                builder.with("trustCertificateKeyStorePassword", String.valueOf(this.sslTrustStorePassword()));
                builder.with("trustStorePassword", String.valueOf(this.sslTrustStorePassword()));
            }
            if (!Strings.isNullOrBlank((String)this.sslKeyStore())) {
                builder.with("clientCertificateKeyStoreUrl", "file:" + this.sslKeyStore());
            }
            if (!Objects.isNull(this.sslKeyStorePassword())) {
                builder.with("clientCertificateKeyStorePassword", String.valueOf(this.sslKeyStorePassword()));
            }
        }
        return JdbcConfiguration.adapt((Configuration)builder.build());
    }

    protected Duration getConnectionTimeout(Configuration configuration) {
        return Duration.ofMillis(configuration.getLong(BinlogConnectorConfig.CONNECTION_TIMEOUT_MS));
    }

    protected abstract String getConnectionTimeZonePropertyName();

    protected abstract String resolveConnectionTimeZone(Configuration var1);

    protected abstract JdbcConnection.ConnectionFactory createFactory(Configuration var1);
}

