/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.DebeziumException;
import io.debezium.connector.binlog.jdbc.BinlogConnectorConnection;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.heartbeat.HeartbeatErrorHandler;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.spi.snapshot.Snapshotter;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BinlogSourceTask<P extends Partition, O extends OffsetContext>
extends BaseSourceTask<P, O> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinlogSourceTask.class);

    protected boolean validateSnapshotFeasibility(Snapshotter snapshotter, O offsetContext, BinlogConnectorConnection connection) {
        if (offsetContext == null && !snapshotter.shouldSnapshotData(false, false)) {
            String earliestBinlogFileName = connection.earliestBinlogFilename();
            if (earliestBinlogFileName == null) {
                LOGGER.warn("No binlog appears to be available. Ensure that the database's row-level binlog is enabled.");
            } else if (!earliestBinlogFileName.endsWith("00001")) {
                LOGGER.warn("It is possible the server has purged some binlogs. If this is the case, then using snapshot mode may be required.");
            }
        }
        return false;
    }

    protected void validateBinlogConfiguration(Snapshotter snapshotter, BinlogConnectorConnection connection) {
        if (snapshotter.shouldStream()) {
            if (!connection.isBinlogFormatRow()) {
                throw new DebeziumException("The database server is not configured to use a ROW binlog_format, which is required for this connector to work properly. Change the database configuration to use a binlog_format=ROW and restart the connector.");
            }
            if (!connection.isBinlogRowImageFull()) {
                throw new DebeziumException("The database server is not configured to use a FULL binlog_row_image, which is required for this connector to work properly. Change the database configuration to use a binlog_row_image=FULL and restart the connector.");
            }
        }
    }

    public static class BinlogHeartbeatErrorHandler
    implements HeartbeatErrorHandler {
        public void onError(SQLException exception) throws RuntimeException {
            String sqlErrorId;
            switch (sqlErrorId = exception.getSQLState()) {
                case "42000": {
                    throw new DebeziumException("Could not execute heartbeat action query (Error: " + sqlErrorId + ")", (Throwable)exception);
                }
                case "3D000": {
                    throw new DebeziumException("Could not execute heartbeat action query (Error: " + sqlErrorId + ")", (Throwable)exception);
                }
            }
        }
    }
}

