/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Db2DatabaseSchema;
import io.debezium.connector.db2.Db2OffsetContext;
import io.debezium.connector.db2.Db2Partition;
import io.debezium.connector.db2.Db2SnapshotChangeEventSource;
import io.debezium.connector.db2.Db2StreamingChangeEventSource;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.util.Optional;

public class Db2ChangeEventSourceFactory
implements ChangeEventSourceFactory<Db2Partition, Db2OffsetContext> {
    private final Db2ConnectorConfig configuration;
    private final Db2Connection dataConnection;
    private final Db2Connection metadataConnection;
    private final ErrorHandler errorHandler;
    private final EventDispatcher<Db2Partition, TableId> dispatcher;
    private final Clock clock;
    private final Db2DatabaseSchema schema;

    public Db2ChangeEventSourceFactory(Db2ConnectorConfig configuration, Db2Connection dataConnection, Db2Connection metadataConnection, ErrorHandler errorHandler, EventDispatcher<Db2Partition, TableId> dispatcher, Clock clock, Db2DatabaseSchema schema) {
        this.configuration = configuration;
        this.dataConnection = dataConnection;
        this.metadataConnection = metadataConnection;
        this.errorHandler = errorHandler;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.schema = schema;
    }

    public SnapshotChangeEventSource<Db2Partition, Db2OffsetContext> getSnapshotChangeEventSource(SnapshotProgressListener<Db2Partition> snapshotProgressListener) {
        return new Db2SnapshotChangeEventSource(this.configuration, this.dataConnection, this.schema, this.dispatcher, this.clock, snapshotProgressListener);
    }

    public StreamingChangeEventSource<Db2Partition, Db2OffsetContext> getStreamingChangeEventSource() {
        return new Db2StreamingChangeEventSource(this.configuration, this.dataConnection, this.metadataConnection, this.dispatcher, this.errorHandler, this.clock, this.schema);
    }

    public Optional<IncrementalSnapshotChangeEventSource<Db2Partition, ? extends DataCollectionId>> getIncrementalSnapshotChangeEventSource(Db2OffsetContext offsetContext, SnapshotProgressListener<Db2Partition> snapshotProgressListener, DataChangeEventListener<Db2Partition> dataChangeEventListener) {
        if (Strings.isNullOrEmpty((String)this.configuration.getSignalingDataCollectionId())) {
            return Optional.empty();
        }
        SignalBasedIncrementalSnapshotChangeEventSource incrementalSnapshotChangeEventSource = new SignalBasedIncrementalSnapshotChangeEventSource((RelationalDatabaseConnectorConfig)this.configuration, (JdbcConnection)this.dataConnection, this.dispatcher, (DatabaseSchema)this.schema, this.clock, snapshotProgressListener, dataChangeEventListener);
        return Optional.of(incrementalSnapshotChangeEventSource);
    }
}

