/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import com.ibm.db2.jcc.DB2Driver;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Field;
import io.debezium.connector.db2.Db2ChangeTable;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Db2ObjectNameQuoter;
import io.debezium.connector.db2.Lsn;
import io.debezium.connector.db2.platform.Db2PlatformAdapter;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.util.BoundedConcurrentHashMap;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2Connection
extends JdbcConnection {
    private static final String GET_DATABASE_NAME = "SELECT CURRENT SERVER FROM SYSIBM.SYSDUMMY1";
    private static Logger LOGGER = LoggerFactory.getLogger(Db2Connection.class);
    private static final String STATEMENTS_PLACEHOLDER = "#";
    private static final String LOCK_TABLE = "SELECT * FROM # WITH CS";
    private static final String LSN_TO_TIMESTAMP = "SELECT CURRENT TIMEstamp FROM sysibm.sysdummy1  WHERE ? > X'00000000000000000000000000000000'";
    private static final String GET_LIST_OF_KEY_COLUMNS = "SELECT CAST((t.TBSPACEID * 65536 +  t.TABLEID )AS INTEGER ) as objectid, c.colname,c.colno,c.keyseq FROM syscat.tables  as t inner join syscat.columns as c  on t.tabname = c.tabname and t.tabschema = c.tabschema and c.KEYSEQ > 0 AND t.tbspaceid = CAST(BITAND( ? , 4294901760) / 65536 AS SMALLINT) AND t.tableid=  CAST(BITAND( ? , 65535) AS SMALLINT)";
    private static final int CHANGE_TABLE_DATA_COLUMN_OFFSET = 4;
    private static final String QUOTED_CHARACTER = "\"";
    private static final String URL_PATTERN = "jdbc:db2://${" + String.valueOf(JdbcConfiguration.HOSTNAME) + "}:${" + String.valueOf(JdbcConfiguration.PORT) + "}/${" + String.valueOf(JdbcConfiguration.DATABASE) + "}";
    private static final JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory((String)URL_PATTERN, (String)DB2Driver.class.getName(), (ClassLoader)Db2Connection.class.getClassLoader(), (Field[])new Field[]{JdbcConfiguration.PORT.withDefault(Db2ConnectorConfig.PORT.defaultValueAsString())});
    private final String realDatabaseName;
    private final BoundedConcurrentHashMap<Lsn, Instant> lsnToInstantCache;
    private final Db2ConnectorConfig connectorConfig;
    private final Db2PlatformAdapter platform;

    public Db2Connection(Db2ConnectorConfig config) {
        super(config.getJdbcConfig(), FACTORY, QUOTED_CHARACTER, QUOTED_CHARACTER);
        this.connectorConfig = config;
        this.lsnToInstantCache = new BoundedConcurrentHashMap(100);
        this.realDatabaseName = this.retrieveRealDatabaseName();
        this.platform = this.connectorConfig.getDb2Platform().createAdapter(this.connectorConfig);
    }

    public Lsn getMaxLsn() throws SQLException {
        return (Lsn)this.queryAndMap(this.platform.getMaxLsnQuery(), this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Current maximum lsn is {}", (Object)ret);
            return ret;
        }, "Maximum LSN query must return exactly one value"));
    }

    public void getChangesForTable(TableId tableId, Lsn fromLsn, Lsn toLsn, JdbcConnection.ResultSetConsumer consumer) throws SQLException {
        String query = this.platform.getAllChangesForTableQuery().replace(STATEMENTS_PLACEHOLDER, this.cdcNameForTable(tableId));
        this.prepareQuery(query, statement -> {
            statement.setBytes(1, fromLsn.getBinary());
            statement.setBytes(2, toLsn.getBinary());
        }, consumer);
    }

    public void getChangesForTables(Db2ChangeTable[] changeTables, Lsn intervalFromLsn, Lsn intervalToLsn, JdbcConnection.BlockingMultiResultSetConsumer consumer) throws SQLException, InterruptedException {
        String[] queries = new String[changeTables.length];
        JdbcConnection.StatementPreparer[] preparers = new JdbcConnection.StatementPreparer[changeTables.length];
        int idx = 0;
        for (Db2ChangeTable changeTable : changeTables) {
            String query;
            queries[idx] = query = this.platform.getAllChangesForTableQuery().replace(STATEMENTS_PLACEHOLDER, changeTable.getCaptureInstance());
            LOGGER.trace("Getting changes for table {} in range[{}, {}]", new Object[]{changeTable, intervalFromLsn, intervalToLsn});
            preparers[idx] = statement -> {
                statement.setBytes(1, intervalFromLsn.getBinary());
                statement.setBytes(2, intervalToLsn.getBinary());
            };
            ++idx;
        }
        this.prepareQuery(queries, preparers, consumer);
    }

    public Lsn incrementLsn(Lsn lsn) throws SQLException {
        return lsn.increment();
    }

    public Instant timestampOfLsn(Lsn lsn) throws SQLException {
        String query = LSN_TO_TIMESTAMP;
        if (lsn.getBinary() == null) {
            return null;
        }
        Instant cachedInstant = (Instant)this.lsnToInstantCache.get((Object)lsn);
        if (cachedInstant != null) {
            return cachedInstant;
        }
        return (Instant)this.prepareQueryAndMap(LSN_TO_TIMESTAMP, statement -> statement.setBytes(1, lsn.getBinary()), this.singleResultMapper(rs -> {
            Timestamp ts = rs.getTimestamp(1);
            Instant ret = ts == null ? null : ts.toInstant();
            LOGGER.trace("Timestamp of lsn {} is {}", (Object)lsn, (Object)ret);
            if (ret != null) {
                this.lsnToInstantCache.put((Object)lsn, (Object)ret);
            }
            return ret;
        }, "LSN to timestamp query must return exactly one value"));
    }

    public Optional<Instant> getCurrentTimestamp() throws SQLException {
        return (Optional)this.queryAndMap("SELECT CURRENT_TIMESTAMP result FROM sysibm.sysdummy1", rs -> rs.next() ? Optional.of(rs.getTimestamp(1).toInstant()) : Optional.empty());
    }

    public void lockTable(TableId tableId) throws SQLException {
        String lockTableStmt = LOCK_TABLE.replace(STATEMENTS_PLACEHOLDER, tableId.table());
        this.execute(new String[]{lockTableStmt});
    }

    private String cdcNameForTable(TableId tableId) {
        return Db2ObjectNameQuoter.quoteNameIfNecessary(tableId.schema() + "_" + tableId.table());
    }

    public Set<Db2ChangeTable> listOfChangeTables() throws SQLException {
        return (Set)this.queryAndMap(this.platform.getListOfCdcEnabledTablesQuery(), rs -> {
            HashSet<Db2ChangeTable> changeTables = new HashSet<Db2ChangeTable>();
            while (rs.next()) {
                changeTables.add(new Db2ChangeTable(new TableId("", rs.getString(1), rs.getString(2)), rs.getString(4), rs.getInt(9), Lsn.valueOf(rs.getBytes(5)), Lsn.valueOf(rs.getBytes(6)), this.connectorConfig.getCdcChangeTablesSchema()));
            }
            return changeTables;
        });
    }

    public Set<Db2ChangeTable> listOfNewChangeTables(Lsn fromLsn, Lsn toLsn) throws SQLException {
        return (Set)this.prepareQueryAndMap(this.platform.getListOfNewCdcEnabledTablesQuery(), ps -> {
            ps.setBytes(1, fromLsn.getBinary());
            ps.setBytes(2, toLsn.getBinary());
        }, rs -> {
            HashSet<Db2ChangeTable> changeTables = new HashSet<Db2ChangeTable>();
            while (rs.next()) {
                changeTables.add(new Db2ChangeTable(rs.getString(2), rs.getInt(1), Lsn.valueOf(rs.getBytes(3)), Lsn.valueOf(rs.getBytes(4)), this.connectorConfig.getCdcChangeTablesSchema()));
            }
            return changeTables;
        });
    }

    public Table getTableSchemaFromTable(Db2ChangeTable changeTable) throws SQLException {
        DatabaseMetaData metadata = this.connection().getMetaData();
        ArrayList columns = new ArrayList();
        try (ResultSet rs = metadata.getColumns(null, changeTable.getSourceTableId().schema(), changeTable.getSourceTableId().table(), null);){
            while (rs.next()) {
                this.readTableColumn(rs, changeTable.getSourceTableId(), null).ifPresent(ce -> columns.add(ce.create()));
            }
        }
        List pkColumnNames = this.readPrimaryKeyNames(metadata, changeTable.getSourceTableId());
        Collections.sort(columns);
        return Table.editor().tableId(changeTable.getSourceTableId()).addColumns(columns).setPrimaryKeyNames(pkColumnNames).create();
    }

    public Table getTableSchemaFromChangeTable(Db2ChangeTable changeTable) throws SQLException {
        DatabaseMetaData metadata = this.connection().getMetaData();
        TableId changeTableId = changeTable.getChangeTableId();
        ArrayList columnEditors = new ArrayList();
        try (ResultSet rs2 = metadata.getColumns(null, changeTableId.schema(), changeTableId.table(), null);){
            while (rs2.next()) {
                this.readTableColumn(rs2, changeTableId, null).ifPresent(columnEditors::add);
            }
        }
        List columns = columnEditors.subList(4, columnEditors.size()).stream().map(c -> c.position(c.position() - 4).create()).collect(Collectors.toList());
        ArrayList pkColumnNames = new ArrayList();
        this.prepareQuery(GET_LIST_OF_KEY_COLUMNS, ps -> {
            ps.setInt(1, changeTable.getChangeTableObjectId());
            ps.setInt(1, changeTable.getChangeTableObjectId());
        }, rs -> {
            while (rs.next()) {
                pkColumnNames.add(rs.getString(2));
            }
        });
        Collections.sort(columns);
        return Table.editor().tableId(changeTable.getSourceTableId()).addColumns(columns).setPrimaryKeyNames(pkColumnNames).create();
    }

    public String getNameOfChangeTable(String captureName) {
        return captureName + "_CT";
    }

    public String getRealDatabaseName() {
        return this.realDatabaseName;
    }

    protected boolean isTableUniqueIndexIncluded(String indexName, String columnName) {
        return indexName != null;
    }

    private String retrieveRealDatabaseName() {
        try {
            return (String)this.queryAndMap(GET_DATABASE_NAME, this.singleResultMapper(rs -> rs.getString(1), "Could not retrieve database name"));
        }
        catch (SQLException e) {
            throw new RuntimeException("Couldn't obtain database name", e);
        }
    }

    public String connectionString() {
        return this.connectionString(URL_PATTERN);
    }

    public Optional<Boolean> nullsSortLast() {
        return Optional.of(true);
    }

    public String quotedTableIdString(TableId tableId) {
        StringBuilder quoted = new StringBuilder();
        if (tableId.catalog() != null && !tableId.catalog().isEmpty()) {
            quoted.append(Db2ObjectNameQuoter.quoteNameIfNecessary(tableId.catalog())).append(".");
        }
        if (tableId.schema() != null && !tableId.schema().isEmpty()) {
            quoted.append(Db2ObjectNameQuoter.quoteNameIfNecessary(tableId.schema())).append(".");
        }
        quoted.append(Db2ObjectNameQuoter.quoteNameIfNecessary(tableId.table()));
        return quoted.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcConnection prepareQuery(String[] multiQuery, JdbcConnection.StatementPreparer[] preparers, JdbcConnection.BlockingMultiResultSetConsumer resultConsumer) throws SQLException, InterruptedException {
        ResultSet[] resultSets = new ResultSet[multiQuery.length];
        PreparedStatement[] preparedStatements = new PreparedStatement[multiQuery.length];
        try {
            for (int i = 0; i < multiQuery.length; ++i) {
                PreparedStatement statement;
                String query = multiQuery[i];
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("running '{}'", (Object)query);
                }
                preparedStatements[i] = statement = this.createPreparedStatement(query);
                preparers[i].accept(statement);
                resultSets[i] = statement.executeQuery();
            }
            if (resultConsumer != null) {
                resultConsumer.accept(resultSets);
            }
        }
        finally {
            for (ResultSet resultSet : resultSets) {
                if (resultSet == null) continue;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            for (AutoCloseable autoCloseable : preparedStatements) {
                this.closePreparedStatement((PreparedStatement)autoCloseable);
            }
        }
        return this;
    }

    public JdbcConnection prepareQueryWithBlockingConsumer(String preparedQueryString, JdbcConnection.StatementPreparer preparer, JdbcConnection.BlockingResultSetConsumer resultConsumer) throws SQLException, InterruptedException {
        try (PreparedStatement statement = this.createPreparedStatement(preparedQueryString);){
            preparer.accept(statement);
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultConsumer != null) {
                    resultConsumer.accept(resultSet);
                }
            }
        }
        return this;
    }

    public JdbcConnection prepareQuery(String preparedQueryString) throws SQLException {
        try (PreparedStatement statement = this.createPreparedStatement(preparedQueryString);){
            statement.executeQuery();
        }
        return this;
    }

    public JdbcConnection prepareQuery(String preparedQueryString, JdbcConnection.StatementPreparer preparer, JdbcConnection.ResultSetConsumer resultConsumer) throws SQLException {
        try (PreparedStatement statement = this.createPreparedStatement(preparedQueryString);){
            preparer.accept(statement);
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultConsumer != null) {
                    resultConsumer.accept(resultSet);
                }
            }
        }
        return this;
    }

    public <T> T prepareQueryAndMap(String preparedQueryString, JdbcConnection.StatementPreparer preparer, JdbcConnection.ResultSetMapper<T> mapper) throws SQLException {
        Objects.requireNonNull(mapper, "Mapper must be provided");
        try (PreparedStatement statement = this.createPreparedStatement(preparedQueryString);){
            Object object;
            block12: {
                preparer.accept(statement);
                ResultSet resultSet = statement.executeQuery();
                try {
                    object = mapper.apply(resultSet);
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return (T)object;
        }
    }

    public JdbcConnection prepareUpdate(String stmt, JdbcConnection.StatementPreparer preparer) throws SQLException {
        try (PreparedStatement statement = this.createPreparedStatement(stmt);){
            if (preparer != null) {
                preparer.accept(statement);
            }
            LOGGER.trace("Executing statement '{}'", (Object)stmt);
            statement.execute();
        }
        return this;
    }

    public JdbcConnection prepareQuery(String preparedQueryString, List<?> parameters, JdbcConnection.ParameterResultSetConsumer resultConsumer) throws SQLException {
        try (PreparedStatement statement = this.createPreparedStatement(preparedQueryString);){
            int index = 1;
            for (Object parameter : parameters) {
                statement.setObject(index++, parameter);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultConsumer != null) {
                    resultConsumer.accept(parameters, resultSet);
                }
            }
        }
        return this;
    }

    public TableId createTableId(String databaseName, String schemaName, String tableName) {
        return new TableId(null, schemaName, tableName);
    }

    public boolean validateLogPosition(Partition partition, OffsetContext offset, CommonConnectorConfig config) {
        LOGGER.info("Offset position validation skipped.");
        return true;
    }

    public <T> T singleOptionalValue(String query, JdbcConnection.ResultSetExtractor<T> extractor) throws SQLException {
        return (T)this.queryAndMap(query, rs -> rs.next() ? extractor.apply(rs) : null);
    }

    private PreparedStatement createPreparedStatement(String query) {
        try {
            LOGGER.trace("Creating prepared statement '{}'", (Object)query);
            return this.connection().prepareStatement(query);
        }
        catch (SQLException e) {
            throw new ConnectException((Throwable)e);
        }
    }

    private void closePreparedStatement(PreparedStatement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static class CdcEnabledTable {
        private final String tableId;
        private final String captureName;
        private final Lsn fromLsn;

        private CdcEnabledTable(String tableId, String captureName, Lsn fromLsn) {
            this.tableId = tableId;
            this.captureName = captureName;
            this.fromLsn = fromLsn;
        }

        public String getTableId() {
            return this.tableId;
        }

        public String getCaptureName() {
            return this.captureName;
        }

        public Lsn getFromLsn() {
            return this.fromLsn;
        }
    }
}

