/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.connector.jdbc.QueryBinder;
import io.debezium.connector.jdbc.ValueBindDescriptor;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.hibernate.query.BindableType;
import org.hibernate.query.NativeQuery;
import org.hibernate.type.StandardBasicTypes;

public class NativeQueryBinder
implements QueryBinder {
    private final NativeQuery<?> binder;

    public NativeQueryBinder(NativeQuery<?> binder) {
        this.binder = binder;
    }

    @Override
    public void bind(ValueBindDescriptor valueBindDescriptor) {
        if (valueBindDescriptor.getTargetSqlType() != null) {
            this.binder.setParameter(valueBindDescriptor.getIndex(), (Object)ZonedDateTime.ofInstant(Instant.now(), ZoneOffset.UTC), (BindableType)StandardBasicTypes.ZONED_DATE_TIME_WITH_TIMEZONE);
        } else {
            this.binder.setParameter(valueBindDescriptor.getIndex(), valueBindDescriptor.getValue());
        }
    }
}

