/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.SinkRecordDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;

public class RecordBuffer {
    private final JdbcSinkConnectorConfig connectorConfig;
    private Schema keySchema;
    private Schema valueSchema;
    private final ArrayList<SinkRecordDescriptor> records = new ArrayList();

    public RecordBuffer(JdbcSinkConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    public List<SinkRecordDescriptor> add(SinkRecordDescriptor recordDescriptor) {
        ArrayList<SinkRecordDescriptor> flushed = new ArrayList<SinkRecordDescriptor>();
        if (this.records.isEmpty()) {
            this.keySchema = recordDescriptor.getKeySchema();
            this.valueSchema = recordDescriptor.getValueSchema();
        }
        if (!Objects.equals(this.keySchema, recordDescriptor.getKeySchema()) || !Objects.equals(this.valueSchema, recordDescriptor.getValueSchema())) {
            this.keySchema = recordDescriptor.getKeySchema();
            this.valueSchema = recordDescriptor.getValueSchema();
            flushed.addAll(this.flush());
        }
        this.records.add(recordDescriptor);
        if ((long)this.records.size() >= this.connectorConfig.getBatchSize()) {
            flushed.addAll(this.flush());
        }
        return flushed;
    }

    public List<SinkRecordDescriptor> flush() {
        ArrayList<SinkRecordDescriptor> flushed = new ArrayList<SinkRecordDescriptor>(this.records);
        this.records.clear();
        return flushed;
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }
}

