/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.mysql;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractType;
import io.debezium.connector.jdbc.util.ByteArrayUtils;
import org.apache.kafka.connect.data.Schema;

class BitType
extends AbstractType {
    public static final BitType INSTANCE = new BitType();

    BitType() {
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.data.Bits"};
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return String.format(dialect.getByteArrayFormat(), ByteArrayUtils.getByteArrayAsHex(value));
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        int bitSize = Integer.parseInt((String)schema.parameters().get("length"));
        return String.format("bit(%d)", bitSize);
    }
}

