/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.connect;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.connect.AbstractConnectSchemaType;
import io.debezium.util.Strings;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;

public class ConnectStringType
extends AbstractConnectSchemaType {
    public static final ConnectStringType INSTANCE = new ConnectStringType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"STRING"};
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        int jdbcType;
        int resolvedJdbcType = this.getColumnSqlType(schema);
        if (1111 != resolvedJdbcType) {
            int columnSize = this.getColumnSize(dialect, schema, key, resolvedJdbcType);
            if (columnSize == 0 && (1 == resolvedJdbcType || -15 == resolvedJdbcType)) {
                columnSize = 1;
            }
            if (columnSize > 0) {
                return dialect.getTypeName(resolvedJdbcType, Size.length((long)columnSize));
            }
            return dialect.getTypeName(resolvedJdbcType);
        }
        int n = jdbcType = this.hasNationalizedCharacterSet(schema) ? -9 : 12;
        if (key) {
            return dialect.getTypeName(jdbcType, Size.length((long)this.getMaxSizeInKey(dialect, jdbcType)));
        }
        return dialect.getTypeName(jdbcType);
    }

    private int getColumnSize(DatabaseDialect dialect, Schema schema, boolean key, int jdbcType) {
        int columnSize = Integer.parseInt(this.getSourceColumnSize(schema).orElse("0"));
        if (key) {
            int maxSizeInKey = this.getMaxSizeInKey(dialect, jdbcType);
            columnSize = columnSize > 0 ? Math.min(columnSize, maxSizeInKey) : maxSizeInKey;
        }
        return columnSize;
    }

    private int getMaxSizeInKey(DatabaseDialect dialect, int jdbcType) {
        if (jdbcType == -15 || jdbcType == -9) {
            return dialect.getMaxNVarcharLengthInKey();
        }
        return dialect.getMaxVarcharLengthInKey();
    }

    private int getColumnSqlType(Schema schema) {
        Optional<String> columnType = this.getSourceColumnType(schema);
        if (columnType.isPresent()) {
            String type = columnType.get();
            if (ConnectStringType.isType(type, "CHAR", "CHARACTER", "BPCHAR")) {
                return this.hasNationalizedCharacterSet(schema) ? -15 : 1;
            }
            if (ConnectStringType.isType(type, "NCHAR")) {
                return -15;
            }
            if (ConnectStringType.isType(type, "VARCHAR", "VARCHAR2", "CHARACTER VARYING")) {
                return this.hasNationalizedCharacterSet(schema) ? -9 : 12;
            }
            if (ConnectStringType.isType(type, "NVARCHAR", "NVARCHAR2")) {
                return -9;
            }
        }
        return 1111;
    }

    private static boolean isType(String columnType, String ... possibilities) {
        for (String possibility : possibilities) {
            if (!possibility.equalsIgnoreCase(columnType)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNationalizedCharacterSet(Schema schema) {
        if (schema.parameters() != null) {
            String charsetName = (String)schema.parameters().get("__debezium.source.column.character_set");
            return !Strings.isNullOrEmpty((String)charsetName) && charsetName.toLowerCase().startsWith("utf8");
        }
        return false;
    }
}

