/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.annotation.Immutable;
import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.ValueBindDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.filter.FieldFilterFactory;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.type.Type;
import io.debezium.connector.jdbc.util.SchemaUtils;
import io.debezium.data.Envelope;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class SinkRecordDescriptor {
    private final SinkRecord record;
    private final String topicName;
    private final List<String> keyFieldNames;
    private final List<String> nonKeyFieldNames;
    private final Map<String, FieldDescriptor> fields;
    private final boolean flattened;

    private SinkRecordDescriptor(SinkRecord record, String topicName, List<String> keyFieldNames, List<String> nonKeyFieldNames, Map<String, FieldDescriptor> fields, boolean flattened) {
        this.record = record;
        this.topicName = topicName;
        this.keyFieldNames = keyFieldNames;
        this.nonKeyFieldNames = nonKeyFieldNames;
        this.fields = fields;
        this.flattened = flattened;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public Integer getPartition() {
        return this.record.kafkaPartition();
    }

    public long getOffset() {
        return this.record.kafkaOffset();
    }

    public List<String> getKeyFieldNames() {
        return this.keyFieldNames;
    }

    public List<String> getNonKeyFieldNames() {
        return this.nonKeyFieldNames;
    }

    public Map<String, FieldDescriptor> getFields() {
        return this.fields;
    }

    public boolean isDebeziumSinkRecord() {
        return !this.flattened;
    }

    public boolean isTombstone() {
        return this.record.value() == null && this.record.valueSchema() == null;
    }

    public boolean isDelete() {
        if (!this.isDebeziumSinkRecord()) {
            return this.record.value() == null;
        }
        if (this.record.value() != null) {
            Struct value = (Struct)this.record.value();
            return Envelope.Operation.DELETE.equals((Object)Envelope.Operation.forCode((String)value.getString("op")));
        }
        return false;
    }

    public boolean isTruncate() {
        if (this.isDebeziumSinkRecord()) {
            Struct value = (Struct)this.record.value();
            return Envelope.Operation.TRUNCATE.equals((Object)Envelope.Operation.forCode((String)value.getString("op")));
        }
        return false;
    }

    public Schema getKeySchema() {
        return this.record.keySchema();
    }

    public Schema getValueSchema() {
        return this.record.valueSchema();
    }

    public Struct getKeyStruct(JdbcSinkConnectorConfig.PrimaryKeyMode primaryKeyMode) {
        if (!this.getKeyFieldNames().isEmpty()) {
            switch (primaryKeyMode) {
                case RECORD_KEY: {
                    Schema keySchema = this.record.keySchema();
                    if (keySchema != null && Schema.Type.STRUCT.equals((Object)keySchema.type())) {
                        return (Struct)this.record.key();
                    }
                    throw new ConnectException("No struct-based primary key defined for record key.");
                }
                case RECORD_VALUE: {
                    Schema valueSchema = this.record.valueSchema();
                    if (valueSchema != null && Schema.Type.STRUCT.equals((Object)valueSchema.type())) {
                        return this.getAfterStruct();
                    }
                    throw new ConnectException("No struct-based primary key defined for record value.");
                }
                case RECORD_HEADER: {
                    SchemaBuilder headerSchemaBuilder = SchemaBuilder.struct();
                    this.record.headers().forEach(header -> headerSchemaBuilder.field(header.key(), header.schema()));
                    Schema headerSchema = headerSchemaBuilder.build();
                    Struct headerStruct = new Struct(headerSchema);
                    this.record.headers().forEach(header -> headerStruct.put(header.key(), header.value()));
                    return headerStruct;
                }
            }
        }
        return null;
    }

    public Struct getAfterStruct() {
        if (this.isDebeziumSinkRecord()) {
            return ((Struct)this.record.value()).getStruct("after");
        }
        return (Struct)this.record.value();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final String CONNECT_TOPIC = "__connect_topic";
        private static final String CONNECT_PARTITION = "__connect_partition";
        private static final String CONNECT_OFFSET = "__connect_offset";
        private JdbcSinkConnectorConfig.PrimaryKeyMode primaryKeyMode;
        private Set<String> primaryKeyFields;
        private FieldFilterFactory.FieldNameFilter fieldFilter = FieldFilterFactory.DEFAULT_FILTER;
        private SinkRecord sinkRecord;
        private DatabaseDialect dialect;
        private final List<String> keyFieldNames = new ArrayList<String>();
        private final List<String> nonKeyFieldNames = new ArrayList<String>();
        private final Map<String, FieldDescriptor> allFields = new LinkedHashMap<String, FieldDescriptor>();

        public Builder withDialect(DatabaseDialect dialect) {
            this.dialect = dialect;
            return this;
        }

        public Builder withPrimaryKeyFields(Set<String> primaryKeyFields) {
            this.primaryKeyFields = primaryKeyFields;
            return this;
        }

        public Builder withPrimaryKeyMode(JdbcSinkConnectorConfig.PrimaryKeyMode primaryKeyMode) {
            this.primaryKeyMode = primaryKeyMode;
            return this;
        }

        public Builder withSinkRecord(SinkRecord record) {
            this.sinkRecord = record;
            return this;
        }

        public Builder withFieldFilters(FieldFilterFactory.FieldNameFilter fieldFilter) {
            this.fieldFilter = fieldFilter;
            return this;
        }

        public SinkRecordDescriptor build() {
            boolean truncated;
            Objects.requireNonNull(this.primaryKeyMode, "The primary key mode must be provided.");
            Objects.requireNonNull(this.sinkRecord, "The sink record must be provided.");
            boolean flattened = !this.isTombstone(this.sinkRecord) && this.isFlattened(this.sinkRecord);
            boolean bl = truncated = !flattened && this.isTruncateEvent(this.sinkRecord);
            if (!truncated) {
                this.readSinkRecordKeyData(this.sinkRecord, flattened);
                this.readSinkRecordNonKeyData(this.sinkRecord, flattened);
            }
            return new SinkRecordDescriptor(this.sinkRecord, this.sinkRecord.topic(), this.keyFieldNames, this.nonKeyFieldNames, this.allFields, flattened);
        }

        private boolean isFlattened(SinkRecord record) {
            return record.valueSchema().name() == null || !record.valueSchema().name().contains("Envelope");
        }

        private boolean isTombstone(SinkRecord record) {
            return record.value() == null && record.valueSchema() == null;
        }

        private boolean isTruncateEvent(SinkRecord record) {
            return !this.isTombstone(record) && Envelope.Operation.TRUNCATE.equals((Object)Envelope.Operation.forCode((String)((Struct)record.value()).getString("op")));
        }

        private void readSinkRecordKeyData(SinkRecord record, boolean flattened) {
            switch (this.primaryKeyMode) {
                case NONE: {
                    break;
                }
                case KAFKA: {
                    this.applyKafkaCoordinatesAsPrimaryKey();
                    break;
                }
                case RECORD_KEY: {
                    this.applyRecordKeyAsPrimaryKey(record);
                    break;
                }
                case RECORD_HEADER: {
                    this.applyRecordHeaderAsPrimaryKey(record);
                    break;
                }
                case RECORD_VALUE: {
                    this.applyRecordValueAsPrimaryKey(record, flattened);
                    break;
                }
                default: {
                    throw new ConnectException("Unexpected primary key mode: " + String.valueOf((Object)this.primaryKeyMode));
                }
            }
        }

        private void applyKafkaCoordinatesAsPrimaryKey() {
            this.keyFieldNames.add(CONNECT_TOPIC);
            this.allFields.put(CONNECT_TOPIC, new FieldDescriptor(Schema.STRING_SCHEMA, CONNECT_TOPIC, true, this.dialect));
            this.keyFieldNames.add(CONNECT_PARTITION);
            this.allFields.put(CONNECT_PARTITION, new FieldDescriptor(Schema.INT32_SCHEMA, CONNECT_PARTITION, true, this.dialect));
            this.keyFieldNames.add(CONNECT_OFFSET);
            this.allFields.put(CONNECT_OFFSET, new FieldDescriptor(Schema.INT64_SCHEMA, CONNECT_OFFSET, true, this.dialect));
        }

        private void applyRecordKeyAsPrimaryKey(SinkRecord record) {
            Schema keySchema = record.keySchema();
            if (keySchema == null) {
                throw new ConnectException("Configured primary key mode 'record_key' cannot have null schema");
            }
            if (keySchema.type().isPrimitive()) {
                this.applyPrimitiveRecordKeyAsPrimaryKey(keySchema);
            } else if (Schema.Type.STRUCT.equals((Object)keySchema.type())) {
                this.applyRecordKeyAsPrimaryKey(record.topic(), keySchema);
            } else {
                throw new ConnectException("An unsupported record key schema type detected: " + String.valueOf(keySchema.type()));
            }
        }

        private void applyRecordHeaderAsPrimaryKey(SinkRecord record) {
            if (record.headers() == null || record.headers().isEmpty()) {
                throw new ConnectException("Configured primary key mode 'record_header' cannot have null or empty schema");
            }
            SchemaBuilder headerSchemaBuilder = SchemaBuilder.struct();
            record.headers().forEach(header -> headerSchemaBuilder.field(header.key(), header.schema()));
            Schema headerSchema = headerSchemaBuilder.build();
            this.applyRecordKeyAsPrimaryKey(record.topic(), headerSchema);
        }

        private void applyRecordValueAsPrimaryKey(SinkRecord record, boolean flattened) {
            Schema valueSchema = record.valueSchema();
            if (valueSchema == null) {
                throw new ConnectException("Configured primary key mode 'record_value' cannot have null schema");
            }
            Stream<Object> recordFields = flattened ? record.valueSchema().fields().stream() : ((Struct)record.value()).getStruct("after").schema().fields().stream();
            if (!this.primaryKeyFields.isEmpty()) {
                recordFields = recordFields.filter(field -> this.primaryKeyFields.contains(field.name()));
            }
            recordFields.forEach(field -> this.addKeyField(record.topic(), (Field)field));
        }

        private void applyPrimitiveRecordKeyAsPrimaryKey(Schema keySchema) {
            if (this.primaryKeyFields.isEmpty()) {
                throw new ConnectException("The primary.key.fields configuration must be specified when using a primitive key.");
            }
            this.addKeyField(this.primaryKeyFields.iterator().next(), keySchema);
        }

        private void applyRecordKeyAsPrimaryKey(String topic, Schema keySchema) {
            for (Field field : keySchema.fields()) {
                if (!this.primaryKeyFields.isEmpty() && !this.primaryKeyFields.contains(field.name())) continue;
                this.addKeyField(topic, field);
            }
        }

        private void addKeyField(String topic, Field field) {
            if (this.fieldFilter.matches(topic, field.name())) {
                this.addKeyField(field.name(), field.schema());
            }
        }

        private void addKeyField(String name, Schema schema) {
            FieldDescriptor fieldDescriptor = new FieldDescriptor(schema, name, true, this.dialect);
            this.keyFieldNames.add(fieldDescriptor.getName());
            this.allFields.put(fieldDescriptor.getName(), fieldDescriptor);
        }

        private void readSinkRecordNonKeyData(SinkRecord record, boolean flattened) {
            Schema valueSchema = record.valueSchema();
            if (valueSchema != null) {
                if (flattened) {
                    this.applyNonKeyFields(record.topic(), valueSchema);
                } else {
                    Field after = valueSchema.field("after");
                    if (after == null) {
                        throw new ConnectException("Received an unexpected message type that does not have an 'after' Debezium block");
                    }
                    this.applyNonKeyFields(record.topic(), after.schema());
                }
            }
        }

        private void applyNonKeyFields(String topic, Schema schema) {
            for (Field field : schema.fields()) {
                if (this.keyFieldNames.contains(field.name()) || !this.fieldFilter.matches(topic, field.name())) continue;
                this.applyNonKeyField(field.name(), field.schema());
            }
        }

        private void applyNonKeyField(String name, Schema schema) {
            FieldDescriptor fieldDescriptor = new FieldDescriptor(schema, name, false, this.dialect);
            this.nonKeyFieldNames.add(fieldDescriptor.getName());
            this.allFields.put(fieldDescriptor.getName(), fieldDescriptor);
        }
    }

    @Immutable
    public static class FieldDescriptor {
        private static final Logger LOGGER = LoggerFactory.getLogger(FieldDescriptor.class);
        private final Schema schema;
        private final String name;
        private final String columnName;
        private final boolean key;
        private final Type type;
        private final DatabaseDialect dialect;
        private final String typeName;
        private String queryBinding;

        private FieldDescriptor(Schema schema, String name, boolean key, DatabaseDialect dialect) {
            this.schema = schema;
            this.key = key;
            this.dialect = dialect;
            this.type = dialect.getSchemaType(schema);
            this.typeName = this.type.getTypeName(dialect, schema, key);
            this.name = name;
            this.columnName = SchemaUtils.getSourceColumnName(schema).orElse(name);
            LOGGER.trace("Field [{}] with schema [{}]", (Object)this.name, (Object)schema.type());
            LOGGER.trace("    Type      : {}", (Object)this.type.getClass().getName());
            LOGGER.trace("    Type Name : {}", (Object)this.typeName);
            LOGGER.trace("    Optional  : {}", (Object)schema.isOptional());
            if (schema.parameters() != null && !schema.parameters().isEmpty()) {
                LOGGER.trace("    Parameters: {}", (Object)schema.parameters());
            }
            if (schema.defaultValue() != null) {
                LOGGER.trace("    Def. Value: {}", schema.defaultValue());
            }
        }

        public Schema getSchema() {
            return this.schema;
        }

        public String getName() {
            return this.name;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public boolean isKey() {
            return this.key;
        }

        public Type getType() {
            return this.type;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getQueryBinding(ColumnDescriptor column, Object value) {
            if (this.queryBinding == null) {
                this.queryBinding = this.type.getQueryBinding(column, this.schema, value);
            }
            return this.queryBinding;
        }

        public List<ValueBindDescriptor> bind(int startIndex, Object value) {
            return this.type.bind(startIndex, this.schema, value);
        }

        public String toString() {
            return "FieldDescriptor{schema=" + String.valueOf(this.schema) + ", name='" + this.name + "', key=" + this.key + ", typeName='" + this.typeName + "', type=" + String.valueOf(this.type) + ", columnName='" + this.columnName + "'}";
        }
    }
}

