/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.postgres;

import io.debezium.connector.jdbc.ValueBindDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.type.AbstractType;
import io.debezium.util.Strings;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;

class BitType
extends AbstractType {
    public static final BitType INSTANCE = new BitType();

    BitType() {
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.data.Bits", "BIT", "VARBIT"};
    }

    @Override
    public String getQueryBinding(ColumnDescriptor column, Schema schema, Object value) {
        Optional<String> columnSize;
        Optional<String> columnType;
        if (this.isBitOne(schema) && (columnType = this.getSourceColumnType(schema)).isPresent() && "BIT".equals(columnType.get()) && (columnSize = this.getSourceColumnSize(schema)).isPresent() && "1".equals(columnSize.get())) {
            return "cast(? as bit)";
        }
        return "cast(? as bit varying)";
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return null;
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        if (this.isBitOne(schema)) {
            return "bit";
        }
        int bitSize = Integer.parseInt((String)schema.parameters().get("length"));
        if (Integer.MAX_VALUE == bitSize) {
            return "bit varying";
        }
        Optional<String> columnType = this.getSourceColumnType(schema);
        if (columnType.isPresent() && "VARBIT".equals(columnType.get())) {
            return String.format("bit varying(%d)", bitSize);
        }
        return String.format("bit(%d)", bitSize);
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        if (this.isBitOne(schema) && value instanceof Boolean) {
            return List.of(new ValueBindDescriptor(index, Character.valueOf((Boolean)value != false ? (char)'1' : '0')));
        }
        int length = Integer.parseInt((String)schema.parameters().get("length"));
        String binaryBitString = new BigInteger((byte[])value).toString(2);
        if (length == Integer.MAX_VALUE) {
            return List.of(new ValueBindDescriptor(index, binaryBitString));
        }
        return List.of(new ValueBindDescriptor(index, Strings.justifyRight((String)binaryBitString, (int)length, (char)'0')));
    }

    private boolean isBitOne(Schema schema) {
        return Objects.isNull(schema.name());
    }
}

