/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.filter;

import io.debezium.util.Strings;
import java.util.Arrays;

public class FieldFilterFactory {
    public static FieldNameFilter DEFAULT_FILTER = (topicName, columnName) -> true;

    private static FieldNameFilter createFilter(String fieldList, boolean include) {
        String[] entries = fieldList.split(",");
        return (topicName, fieldName) -> {
            for (String entry : entries) {
                String[] parts = (String[])Arrays.stream(entry.split(":")).map(String::strip).toArray(String[]::new);
                if (parts.length == 2 && parts[0].equals(topicName) && parts[1].equals(fieldName)) {
                    return include;
                }
                if (parts.length != 1 || !parts[0].equals(fieldName)) continue;
                return include;
            }
            return !include;
        };
    }

    private static FieldNameFilter createIncludeFilter(String fieldIncludeList) {
        return FieldFilterFactory.createFilter(fieldIncludeList, true);
    }

    private static FieldNameFilter createExcludeFilter(String fieldExcludeList) {
        return FieldFilterFactory.createFilter(fieldExcludeList, false);
    }

    public static FieldNameFilter createFieldFilter(String includeList, String excludeList) {
        if (!Strings.isNullOrEmpty((String)excludeList)) {
            return FieldFilterFactory.createExcludeFilter(excludeList);
        }
        if (!Strings.isNullOrEmpty((String)includeList)) {
            return FieldFilterFactory.createIncludeFilter(includeList);
        }
        return DEFAULT_FILTER;
    }

    @FunctionalInterface
    public static interface FieldNameFilter {
        public boolean matches(String var1, String var2);
    }
}

