/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.relational;

import io.debezium.annotation.Immutable;
import java.util.Objects;

@Immutable
public class ColumnDescriptor {
    private final String columnName;
    private final int jdbcType;
    private final String typeName;
    private final int precision;
    private final int scale;
    private final Nullability nullability;
    private final boolean autoIncrement;
    private final boolean primaryKey;

    private ColumnDescriptor(String columnName, int jdbcType, String typeName, int precision, int scale, Nullability nullability, boolean autoIncrement, boolean primaryKey) {
        this.columnName = columnName;
        this.jdbcType = jdbcType;
        this.typeName = typeName;
        this.precision = precision;
        this.scale = scale;
        this.nullability = nullability;
        this.autoIncrement = autoIncrement;
        this.primaryKey = primaryKey;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public Nullability getNullability() {
        return this.nullability;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Nullability {
        NULL,
        NOT_NULL;

    }

    public static class Builder {
        private String columnName;
        private int jdbcType;
        private String typeName;
        private int precision;
        private int scale;
        private Nullability nullability = Nullability.NULL;
        private boolean autoIncrement;
        private boolean primaryKey;

        private Builder() {
        }

        public Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder jdbcType(int jdbcType) {
            this.jdbcType = jdbcType;
            return this;
        }

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder precision(int precision) {
            this.precision = precision;
            return this;
        }

        public Builder scale(int scale) {
            this.scale = scale;
            return this;
        }

        public Builder nullable(boolean nullable) {
            this.nullability = nullable ? Nullability.NULL : Nullability.NOT_NULL;
            return this;
        }

        public Builder autoIncrement(boolean autoIncrement) {
            this.autoIncrement = autoIncrement;
            return this;
        }

        public Builder primarykey(boolean primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public ColumnDescriptor build() {
            Objects.requireNonNull(this.columnName, "A column name is required");
            Objects.requireNonNull(this.typeName, "A type name is required");
            return new ColumnDescriptor(this.columnName, this.jdbcType, this.typeName, this.precision, this.scale, this.nullability, this.autoIncrement, this.primaryKey);
        }
    }
}

