/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.connect;

import io.debezium.connector.jdbc.ValueBindDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.type.AbstractTimeType;
import io.debezium.connector.jdbc.util.DateTimeUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;

public class ConnectTimeType
extends AbstractTimeType {
    public static final ConnectTimeType INSTANCE = new ConnectTimeType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"org.apache.kafka.connect.data.Time"};
    }

    @Override
    public String getQueryBinding(ColumnDescriptor column, Schema schema, Object value) {
        return this.getDialect().getTimeQueryBinding();
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return dialect.getFormattedTime(DateTimeUtils.toZonedDateTimeFromDate((Date)value, this.getDatabaseTimeZone()));
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        if (value instanceof Date) {
            LocalTime localTime = DateTimeUtils.toLocalTimeFromUtcDate((Date)value);
            LocalDateTime localDateTime = localTime.atDate(LocalDate.now());
            if (this.getDialect().isTimeZoneSet()) {
                return List.of(new ValueBindDescriptor(index, localDateTime.atZone(this.getDatabaseTimeZone().toZoneId()).toLocalDateTime().toLocalTime()));
            }
            return List.of(new ValueBindDescriptor(index, localDateTime.toLocalTime()));
        }
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value, value.getClass().getName()));
    }
}

