/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.annotation.Immutable;
import io.debezium.bindings.kafka.KafkaDebeziumSinkRecord;
import io.debezium.connector.jdbc.JdbcSinkRecord;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.field.JdbcFieldDescriptor;
import io.debezium.sink.SinkConnectorConfig;
import io.debezium.sink.field.FieldDescriptor;
import io.debezium.sink.filter.FieldFilterFactory;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;

@Immutable
public class JdbcKafkaSinkRecord
extends KafkaDebeziumSinkRecord
implements JdbcSinkRecord {
    private final Map<String, JdbcFieldDescriptor> jdbcFields = new LinkedHashMap<String, JdbcFieldDescriptor>();
    private final SinkConnectorConfig.PrimaryKeyMode primaryKeyMode;
    private final Set<String> configuredPrimaryKeyFields;
    private final FieldFilterFactory.FieldNameFilter fieldFilter;
    private final DatabaseDialect dialect;
    private Struct filteredKey = null;
    private Set<String> keyFieldNames = null;
    private Set<String> nonKeyFieldNames = null;

    public JdbcKafkaSinkRecord(SinkRecord record, SinkConnectorConfig.PrimaryKeyMode primaryKeyMode, Set<String> configuredPrimaryKeyFields, FieldFilterFactory.FieldNameFilter fieldFilter, String cloudEventsSchemaNamePattern, DatabaseDialect dialect) {
        super(record, cloudEventsSchemaNamePattern);
        this.primaryKeyMode = primaryKeyMode;
        this.configuredPrimaryKeyFields = configuredPrimaryKeyFields;
        this.fieldFilter = fieldFilter;
        this.dialect = dialect;
        if (SinkConnectorConfig.PrimaryKeyMode.KAFKA.equals((Object)primaryKeyMode)) {
            Map kafkaFields = this.kafkaFields();
            kafkaFields.forEach((name, field) -> this.jdbcFields.put((String)name, new JdbcFieldDescriptor((FieldDescriptor)field, dialect.getSchemaType(field.getSchema()), true)));
            this.allFields.putAll(kafkaFields);
            this.keyFieldNames = new LinkedHashSet(kafkaFields.keySet());
        }
    }

    @Override
    public Struct filteredKey() {
        if (null == this.filteredKey) {
            this.filteredKey = this.getFilteredKey(this.primaryKeyMode, this.configuredPrimaryKeyFields, this.fieldFilter);
        }
        return this.filteredKey;
    }

    @Override
    public Set<String> keyFieldNames() {
        if (null == this.keyFieldNames) {
            Struct filteredKey = this.filteredKey();
            this.keyFieldNames = null == filteredKey ? Set.of() : (Set)filteredKey.schema().fields().stream().map(field -> {
                String fieldName = field.name();
                FieldDescriptor descriptor = new FieldDescriptor(field.schema(), fieldName, true);
                this.allFields.put(fieldName, descriptor);
                this.jdbcFields.put(fieldName, new JdbcFieldDescriptor(descriptor, this.dialect.getSchemaType(field.schema()), true));
                return fieldName;
            }).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return this.keyFieldNames;
    }

    @Override
    public Set<String> nonKeyFieldNames() {
        if (null == this.nonKeyFieldNames) {
            Struct filteredPayload = this.getFilteredPayload(this.fieldFilter);
            this.nonKeyFieldNames = null == filteredPayload ? Set.of() : (Set)filteredPayload.schema().fields().stream().map(field -> {
                String fieldName = field.name();
                if (this.allFields.containsKey(fieldName) || this.keyFieldNames.contains(fieldName)) {
                    return null;
                }
                FieldDescriptor descriptor = new FieldDescriptor(field.schema(), fieldName, false);
                this.allFields.put(fieldName, descriptor);
                this.jdbcFields.put(fieldName, new JdbcFieldDescriptor(descriptor, this.dialect.getSchemaType(field.schema()), false));
                return fieldName;
            }).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return this.nonKeyFieldNames;
    }

    @Override
    public Map<String, JdbcFieldDescriptor> jdbcFields() {
        if (!this.isTruncate() && !this.isTombstone() && this.jdbcFields.isEmpty()) {
            if (null == this.keyFieldNames) {
                this.keyFieldNames();
            }
            if (null == this.nonKeyFieldNames) {
                this.nonKeyFieldNames();
            }
        }
        return this.jdbcFields;
    }

    public String toString() {
        return "JdbcKafkaSinkRecord{jdbcFields=" + String.valueOf(this.jdbcFields) + ", primaryKeyMode=" + String.valueOf(this.primaryKeyMode) + ", configuredPrimaryKeyFields=" + String.valueOf(this.configuredPrimaryKeyFields) + ", keyFieldNames=" + String.valueOf(this.keyFieldNames()) + ", nonKeyFieldNames=" + String.valueOf(this.nonKeyFieldNames()) + "}";
    }
}

