/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.JdbcSinkRecord;
import io.debezium.connector.jdbc.QueryBinder;
import io.debezium.connector.jdbc.QueryBinderResolver;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.field.JdbcFieldDescriptor;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import io.debezium.util.Stopwatch;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Set;
import org.apache.kafka.connect.data.Struct;
import org.hibernate.SharedSessionContract;
import org.hibernate.Transaction;
import org.hibernate.jdbc.Work;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordWriter.class);
    private final SharedSessionContract session;
    private final QueryBinderResolver queryBinderResolver;
    private final JdbcSinkConnectorConfig config;
    private final DatabaseDialect dialect;

    public RecordWriter(SharedSessionContract session, QueryBinderResolver queryBinderResolver, JdbcSinkConnectorConfig config, DatabaseDialect dialect) {
        this.session = session;
        this.queryBinderResolver = queryBinderResolver;
        this.config = config;
        this.dialect = dialect;
    }

    public void write(List<JdbcSinkRecord> records, String sqlStatement) {
        Stopwatch writeStopwatch = Stopwatch.reusable();
        writeStopwatch.start();
        Transaction transaction = this.session.beginTransaction();
        try {
            this.session.doWork(this.processBatch(records, sqlStatement));
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            throw e;
        }
        writeStopwatch.stop();
        LOGGER.trace("[PERF] Total write execution time {}", (Object)writeStopwatch.durations());
    }

    private Work processBatch(List<JdbcSinkRecord> records, String sqlStatement) {
        return conn -> {
            try (PreparedStatement prepareStatement = conn.prepareStatement(sqlStatement);){
                QueryBinder queryBinder = this.queryBinderResolver.resolve(prepareStatement);
                Stopwatch allbindStopwatch = Stopwatch.reusable();
                allbindStopwatch.start();
                for (JdbcSinkRecord record : records) {
                    Stopwatch singlebindStopwatch = Stopwatch.reusable();
                    singlebindStopwatch.start();
                    this.bindValues(record, queryBinder);
                    singlebindStopwatch.stop();
                    Stopwatch addBatchStopwatch = Stopwatch.reusable();
                    addBatchStopwatch.start();
                    prepareStatement.addBatch();
                    addBatchStopwatch.stop();
                    LOGGER.trace("[PERF] Bind single record execution time {}", (Object)singlebindStopwatch.durations());
                    LOGGER.trace("[PERF] Add batch execution time {}", (Object)addBatchStopwatch.durations());
                }
                allbindStopwatch.stop();
                LOGGER.trace("[PERF] All records bind execution time {}", (Object)allbindStopwatch.durations());
                Stopwatch executeStopwatch = Stopwatch.reusable();
                executeStopwatch.start();
                int[] batchResult = prepareStatement.executeBatch();
                executeStopwatch.stop();
                for (int updateCount : batchResult) {
                    if (updateCount != -3) continue;
                    throw new BatchUpdateException("Execution failed for part of the batch", batchResult);
                }
                LOGGER.trace("[PERF] Execute batch execution time {}", (Object)executeStopwatch.durations());
            }
        };
    }

    private void bindValues(JdbcSinkRecord record, QueryBinder queryBinder) {
        if (record.isDelete()) {
            this.bindKeyValuesToQuery(record, queryBinder, 1);
            return;
        }
        switch (this.config.getInsertMode()) {
            case INSERT: 
            case UPSERT: {
                int index = this.bindKeyValuesToQuery(record, queryBinder, 1);
                this.bindNonKeyValuesToQuery(record, queryBinder, index);
                break;
            }
            case UPDATE: {
                int index = this.bindNonKeyValuesToQuery(record, queryBinder, 1);
                this.bindKeyValuesToQuery(record, queryBinder, index);
            }
        }
    }

    private int bindKeyValuesToQuery(JdbcSinkRecord record, QueryBinder query, int index) {
        Struct keySource = record.filteredKey();
        if (keySource != null) {
            index = this.bindFieldValuesToQuery(record, query, index, keySource, record.keyFieldNames());
        }
        return index;
    }

    private int bindNonKeyValuesToQuery(JdbcSinkRecord record, QueryBinder query, int index) {
        return this.bindFieldValuesToQuery(record, query, index, record.getPayload(), record.nonKeyFieldNames());
    }

    private int bindFieldValuesToQuery(JdbcSinkRecord record, QueryBinder query, int index, Struct source, Set<String> fieldNames) {
        for (String fieldName : fieldNames) {
            JdbcFieldDescriptor field = record.jdbcFields().get(fieldName);
            Object value = field.getSchema().isOptional() ? source.getWithoutDefault(fieldName) : source.get(fieldName);
            List<ValueBindDescriptor> boundValues = this.dialect.bindValue(field, index, value);
            boundValues.forEach(query::bind);
            index += boundValues.size();
        }
        return index;
    }
}

