/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect;

import io.debezium.DebeziumException;
import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.JdbcSinkRecord;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.dialect.SqlStatementBuilder;
import io.debezium.connector.jdbc.field.JdbcFieldDescriptor;
import io.debezium.connector.jdbc.naming.ColumnNamingStrategy;
import io.debezium.connector.jdbc.relational.TableDescriptor;
import io.debezium.connector.jdbc.type.JdbcType;
import io.debezium.connector.jdbc.type.connect.AbstractConnectSchemaType;
import io.debezium.connector.jdbc.type.connect.ConnectBooleanType;
import io.debezium.connector.jdbc.type.connect.ConnectBytesType;
import io.debezium.connector.jdbc.type.connect.ConnectDateType;
import io.debezium.connector.jdbc.type.connect.ConnectDecimalType;
import io.debezium.connector.jdbc.type.connect.ConnectFloat32Type;
import io.debezium.connector.jdbc.type.connect.ConnectFloat64Type;
import io.debezium.connector.jdbc.type.connect.ConnectInt16Type;
import io.debezium.connector.jdbc.type.connect.ConnectInt32Type;
import io.debezium.connector.jdbc.type.connect.ConnectInt64Type;
import io.debezium.connector.jdbc.type.connect.ConnectInt8Type;
import io.debezium.connector.jdbc.type.connect.ConnectMapToConnectStringType;
import io.debezium.connector.jdbc.type.connect.ConnectStringType;
import io.debezium.connector.jdbc.type.connect.ConnectTimeType;
import io.debezium.connector.jdbc.type.connect.ConnectTimestampType;
import io.debezium.connector.jdbc.type.debezium.DateType;
import io.debezium.connector.jdbc.type.debezium.DebeziumZonedTimestampType;
import io.debezium.connector.jdbc.type.debezium.MicroTimeType;
import io.debezium.connector.jdbc.type.debezium.MicroTimestampType;
import io.debezium.connector.jdbc.type.debezium.NanoTimeType;
import io.debezium.connector.jdbc.type.debezium.NanoTimestampType;
import io.debezium.connector.jdbc.type.debezium.TimeType;
import io.debezium.connector.jdbc.type.debezium.TimestampType;
import io.debezium.connector.jdbc.type.debezium.VariableScaleDecimalType;
import io.debezium.connector.jdbc.type.debezium.ZonedTimeType;
import io.debezium.metadata.CollectionId;
import io.debezium.relational.TableId;
import io.debezium.sink.SinkConnectorConfig;
import io.debezium.sink.column.ColumnDescriptor;
import io.debezium.sink.field.FieldDescriptor;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import io.debezium.util.Strings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralDatabaseDialect
implements DatabaseDialect {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralDatabaseDialect.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneOffset.UTC);
    private final JdbcSinkConnectorConfig connectorConfig;
    private final Dialect dialect;
    private final DdlTypeRegistry ddlTypeRegistry;
    private final IdentifierHelper identifierHelper;
    private final ColumnNamingStrategy columnNamingStrategy;
    private final Map<String, JdbcType> typeRegistry = new HashMap<String, JdbcType>();
    private final boolean jdbcTimeZone;

    public GeneralDatabaseDialect(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
        this.connectorConfig = config;
        this.dialect = GeneralDatabaseDialect.unwrapSessionFactory(sessionFactory).getJdbcServices().getDialect();
        this.ddlTypeRegistry = GeneralDatabaseDialect.unwrapSessionFactory(sessionFactory).getTypeConfiguration().getDdlTypeRegistry();
        this.identifierHelper = GeneralDatabaseDialect.unwrapSessionFactory(sessionFactory).getJdbcServices().getJdbcEnvironment().getIdentifierHelper();
        this.columnNamingStrategy = this.connectorConfig.getColumnNamingStrategy();
        String jdbcTimeZone = config.getHibernateConfiguration().getProperty("hibernate.jdbc.time_zone");
        this.jdbcTimeZone = !Strings.isNullOrEmpty((String)jdbcTimeZone);
        this.registerTypes();
        LOGGER.info("Database TimeZone: {}", (Object)this.getDatabaseTimeZone(sessionFactory));
    }

    @Override
    public CollectionId getCollectionId(String tableName) {
        String[] parts = TableId.parseParts((String)tableName);
        if (parts.length == 3) {
            return new CollectionId(parts[0], parts[1], parts[2]);
        }
        if (parts.length == 2) {
            NameQualifierSupport nameQualifierSupport = this.dialect.getNameQualifierSupport();
            if (nameQualifierSupport != null && nameQualifierSupport.supportsCatalogs() && !nameQualifierSupport.supportsSchemas()) {
                return new CollectionId(parts[0], null, parts[1]);
            }
            return new CollectionId(parts[0], parts[1]);
        }
        if (parts.length == 1) {
            return new CollectionId(parts[0]);
        }
        throw new DebeziumException("Failed to parse table name into TableId: " + tableName);
    }

    @Override
    public boolean tableExists(Connection connection, CollectionId collectionId) throws SQLException {
        if (this.isIdentifierUppercaseWhenNotQuoted() && !this.getConfig().isQuoteIdentifiers()) {
            collectionId = collectionId.toUpperCase();
        }
        try (ResultSet rs = connection.getMetaData().getTables(collectionId.realm(), collectionId.namespace(), collectionId.name(), null);){
            boolean bl = rs.next();
            return bl;
        }
    }

    @Override
    public TableDescriptor readTable(Connection connection, CollectionId collectionId) throws SQLException {
        DatabaseMetaData metadata;
        TableDescriptor.Builder table;
        block23: {
            if (this.isIdentifierUppercaseWhenNotQuoted() && !this.getConfig().isQuoteIdentifiers()) {
                collectionId = collectionId.toUpperCase();
            }
            table = TableDescriptor.builder();
            metadata = connection.getMetaData();
            try (ResultSet rs = metadata.getTables(collectionId.realm(), collectionId.namespace(), collectionId.name(), null);){
                if (rs.next()) {
                    table.catalogName(rs.getString(1));
                    table.schemaName(rs.getString(2));
                    table.tableName(collectionId.name());
                    String tableType = rs.getString(4);
                    table.type(Strings.isNullOrBlank((String)tableType) ? "TABLE" : tableType);
                    break block23;
                }
                throw new IllegalStateException("Failed to find table: " + collectionId.toFullIdentiferString());
            }
        }
        ArrayList<String> primaryKeyColumNames = new ArrayList<String>();
        try (ResultSet rs = metadata.getPrimaryKeys(collectionId.realm(), collectionId.namespace(), collectionId.name());){
            while (rs.next()) {
                String columnName = rs.getString(4);
                primaryKeyColumNames.add(columnName);
                table.keyColumn(columnName);
            }
        }
        rs = metadata.getColumns(collectionId.realm(), collectionId.namespace(), collectionId.name(), null);
        try {
            int resultSizeColumnSize = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                String autoIncrementValue;
                String columnName = rs.getString(4);
                int jdbcType = rs.getInt(5);
                String typeName = rs.getString(6);
                int precision = rs.getInt(7);
                int scale = rs.getInt(9);
                int nullable = rs.getInt(11);
                String autoIncrement = "no";
                if (resultSizeColumnSize >= 23 && !Strings.isNullOrBlank((String)(autoIncrementValue = rs.getString(23)))) {
                    autoIncrement = autoIncrementValue;
                }
                ColumnDescriptor column = ColumnDescriptor.builder().columnName(columnName).jdbcType(jdbcType).typeName(typeName).precision(precision).scale(scale).nullable(GeneralDatabaseDialect.isColumnNullable(columnName, primaryKeyColumNames, nullable)).autoIncrement("yes".equalsIgnoreCase(autoIncrement)).primarykey(primaryKeyColumNames.contains(columnName)).build();
                table.column(column);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return table.build();
    }

    @Override
    public Set<String> resolveMissingFields(JdbcSinkRecord record, TableDescriptor table) {
        LinkedHashSet<String> missingFields = new LinkedHashSet<String>();
        for (FieldDescriptor fieldDescriptor : record.jdbcFields().values()) {
            String columnName = this.resolveColumnName(fieldDescriptor);
            if (table.hasColumn(columnName)) continue;
            missingFields.add(fieldDescriptor.getName());
        }
        return missingFields;
    }

    protected String resolveColumnName(FieldDescriptor field) {
        String columnName = this.columnNamingStrategy.resolveColumnName(field.getColumnName());
        if (!this.getConfig().isQuoteIdentifiers()) {
            String columnIdentifier;
            if (!(!this.isIdentifierUppercaseWhenNotQuoted() || (columnIdentifier = this.toIdentifier(columnName)).startsWith("\"") && columnIdentifier.endsWith("\""))) {
                return columnName.toUpperCase();
            }
            return columnName.toLowerCase();
        }
        return columnName;
    }

    @Override
    public String getCreateTableStatement(JdbcSinkRecord record, CollectionId collectionId) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("CREATE TABLE ");
        builder.append(this.getQualifiedTableName(collectionId));
        builder.append(" (");
        Map allFields = record.allFields();
        builder.appendLists(", ", record.keyFieldNames(), record.nonKeyFieldNames(), name -> {
            FieldDescriptor field = (FieldDescriptor)allFields.get(name);
            String columnName = this.toIdentifier(this.resolveColumnName(field));
            Schema fieldSchema = field.getSchema();
            String columnType = this.getSchemaType(fieldSchema).getTypeName(fieldSchema, field.isKey());
            StringBuilder columnSpec = new StringBuilder();
            columnSpec.append(columnName).append(" ").append(columnType);
            this.addColumnDefaultValue(field, columnSpec);
            if (field.isKey()) {
                columnSpec.append(" NOT NULL");
            } else {
                columnSpec.append(fieldSchema.isOptional() ? " NULL" : " NOT NULL");
            }
            return columnSpec.toString();
        });
        if (!record.keyFieldNames().isEmpty()) {
            builder.append(", PRIMARY KEY(");
            builder.appendList(", ", record.keyFieldNames(), name -> {
                FieldDescriptor field = (FieldDescriptor)allFields.get(name);
                return this.toIdentifier(this.columnNamingStrategy.resolveColumnName(field.getColumnName()));
            });
            builder.append(")");
        }
        builder.append(")");
        return builder.build();
    }

    @Override
    public String getAlterTablePrefix() {
        return "ADD (";
    }

    @Override
    public String getAlterTableSuffix() {
        return ")";
    }

    @Override
    public String getAlterTableColumnPrefix() {
        return "";
    }

    @Override
    public String getAlterTableColumnSuffix() {
        return "";
    }

    @Override
    public String getAlterTableColumnDelimiter() {
        return ", ";
    }

    @Override
    public String getAlterTableStatement(TableDescriptor table, JdbcSinkRecord record, Set<String> missingFields) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("ALTER TABLE ");
        builder.append(this.getQualifiedTableName(table.getId()));
        builder.append(" ");
        builder.append(this.getAlterTablePrefix());
        builder.appendList(this.getAlterTableColumnDelimiter(), missingFields, name -> {
            FieldDescriptor field = (FieldDescriptor)record.allFields().get(name);
            StringBuilder addColumnSpec = new StringBuilder();
            addColumnSpec.append(this.getAlterTableColumnPrefix());
            addColumnSpec.append(" ");
            addColumnSpec.append(this.toIdentifier(this.columnNamingStrategy.resolveColumnName(field.getColumnName())));
            Schema fieldSchema = field.getSchema();
            addColumnSpec.append(" ").append(this.getSchemaType(fieldSchema).getTypeName(fieldSchema, field.isKey()));
            this.addColumnDefaultValue(field, addColumnSpec);
            addColumnSpec.append(field.getSchema().isOptional() ? " NULL" : " NOT NULL");
            addColumnSpec.append(this.getAlterTableColumnSuffix());
            return addColumnSpec.toString();
        });
        builder.append(this.getAlterTableSuffix());
        return builder.build();
    }

    @Override
    public String getInsertStatement(TableDescriptor table, JdbcSinkRecord record) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getQualifiedTableName(table.getId()));
        builder.append(" (");
        builder.appendLists(", ", record.keyFieldNames(), record.nonKeyFieldNames(), name -> this.columnNameFromField((String)name, record));
        builder.append(") VALUES (");
        builder.appendLists(", ", record.keyFieldNames(), record.nonKeyFieldNames(), name -> this.columnQueryBindingFromField((String)name, table, record));
        builder.append(")");
        return builder.build();
    }

    @Override
    public String getUpsertStatement(TableDescriptor table, JdbcSinkRecord record) {
        throw new UnsupportedOperationException("Upsert configurations are not supported for this dialect");
    }

    @Override
    public String getUpdateStatement(TableDescriptor table, JdbcSinkRecord record) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("UPDATE ");
        builder.append(this.getQualifiedTableName(table.getId()));
        builder.append(" SET ");
        builder.appendList(", ", record.nonKeyFieldNames(), name -> this.columnNameEqualsBinding((String)name, table, record));
        if (!record.keyFieldNames().isEmpty()) {
            builder.append(" WHERE ");
            builder.appendList(" AND ", record.keyFieldNames(), name -> this.columnNameEqualsBinding((String)name, table, record));
        }
        return builder.build();
    }

    @Override
    public String getDeleteStatement(TableDescriptor table, JdbcSinkRecord record) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("DELETE FROM ");
        builder.append(this.getQualifiedTableName(table.getId()));
        if (!record.keyFieldNames().isEmpty()) {
            builder.append(" WHERE ");
            builder.appendList(" AND ", record.keyFieldNames(), name -> this.columnNameEqualsBinding((String)name, table, record));
        }
        return builder.build();
    }

    @Override
    public String getTruncateStatement(TableDescriptor table) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("TRUNCATE TABLE ");
        builder.append(this.getQualifiedTableName(table.getId()));
        return builder.build();
    }

    @Override
    public String getQueryBindingWithValueCast(ColumnDescriptor column, Schema schema, JdbcType type) {
        return "?";
    }

    @Override
    public List<ValueBindDescriptor> bindValue(JdbcFieldDescriptor field, int startIndex, Object value) {
        LOGGER.trace("Bind field '{}' at position {} with type {}: {}", new Object[]{field.getName(), startIndex, this.getSchemaType(field.getSchema()).getClass().getName(), value});
        return field.bind(startIndex, value);
    }

    @Override
    public int getMaxVarcharLengthInKey() {
        return this.dialect.getMaxVarcharLength();
    }

    @Override
    public int getMaxNVarcharLengthInKey() {
        return this.getMaxVarcharLengthInKey();
    }

    @Override
    public int getMaxVarbinaryLength() {
        return this.dialect.getMaxVarbinaryLength();
    }

    @Override
    public boolean isTimeZoneSet() {
        return this.jdbcTimeZone;
    }

    @Override
    public boolean shouldBindTimeWithTimeZoneAsDatabaseTimeZone() {
        return false;
    }

    @Override
    public JdbcType getSchemaType(Schema schema) {
        JdbcType type;
        String columnType;
        JdbcType type2;
        if (!Objects.isNull(schema.name()) && !Objects.isNull(type2 = this.typeRegistry.get(schema.name()))) {
            LOGGER.trace("Schema '{}' resolved by name from registry to type '{}'", (Object)schema.name(), (Object)type2);
            return type2;
        }
        if (!(Objects.isNull(schema.parameters()) || Objects.isNull(columnType = (String)schema.parameters().get("__debezium.source.column.type")) || Objects.isNull(type = this.typeRegistry.get(columnType)) || type instanceof AbstractConnectSchemaType)) {
            LOGGER.trace("Schema '{}' resolved by name from registry to type '{}' using parameter '{}'", new Object[]{schema, type, columnType});
            return type;
        }
        type2 = this.typeRegistry.get(schema.type().name());
        if (!Objects.isNull(type2)) {
            LOGGER.trace("Schema type '{}' resolved by name from registry to type '{}'", (Object)schema.type().name(), (Object)type2);
            return type2;
        }
        switch (schema.name()) {
            case "io.debezium.data.SparseDoubleVector": 
            case "io.debezium.data.FloatVector": 
            case "io.debezium.data.DoubleVector": {
                throw new ConnectException(String.format("Dialect does not support schema type %s. Please use the VectorToJsonConverter transform in your connector configuration to ingest data of this type.", schema.name()));
            }
        }
        throw new ConnectException(String.format("Failed to resolve column type for schema: %s (%s)", schema.type(), schema.name()));
    }

    @Override
    public DatabaseVersion getVersion() {
        return this.dialect.getVersion();
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return this.dialect.getDefaultDecimalPrecision();
    }

    @Override
    public int getDefaultTimestampPrecision() {
        return this.dialect.getDefaultTimestampPrecision();
    }

    @Override
    public boolean isNegativeScaleAllowed() {
        return false;
    }

    @Override
    public String getJdbcTypeName(int jdbcType) {
        return switch (jdbcType) {
            case 12 -> this.getJdbcTypeName(-1);
            case -9 -> this.getJdbcTypeName(-16);
            case -3 -> this.getJdbcTypeName(-4);
            default -> this.ddlTypeRegistry.getTypeName(jdbcType, this.dialect);
        };
    }

    @Override
    public String getJdbcTypeName(int jdbcType, Size size) {
        return this.ddlTypeRegistry.getTypeName(jdbcType, size);
    }

    @Override
    public String getTimestampPositiveInfinityValue() {
        return Timestamp.from(Instant.MAX).toString();
    }

    @Override
    public String getTimestampNegativeInfinityValue() {
        return Timestamp.from(Instant.MIN).toString();
    }

    @Override
    public String getByteArrayFormat() {
        return "x'%s'";
    }

    @Override
    public String getFormattedBoolean(boolean value) {
        return value ? "1" : "0";
    }

    @Override
    public String getFormattedDate(TemporalAccessor value) {
        return String.format("'%s'", DATE_FORMATTER.format(value));
    }

    @Override
    public String getFormattedTime(TemporalAccessor value) {
        return String.format("'%s'", DateTimeFormatter.ISO_TIME.format(value));
    }

    @Override
    public String getFormattedTimeWithTimeZone(String value) {
        return String.format("'%s'", value);
    }

    @Override
    public String getFormattedDateTime(TemporalAccessor value) {
        return String.format("'%s'", DateTimeFormatter.ISO_DATE_TIME.format(value));
    }

    @Override
    public String getFormattedDateTimeWithNanos(TemporalAccessor value) {
        return this.getFormattedDateTime(value);
    }

    @Override
    public String getFormattedTimestamp(TemporalAccessor value) {
        return String.format("'%s'", DateTimeFormatter.ISO_ZONED_DATE_TIME.format(value));
    }

    @Override
    public String getFormattedTimestampWithTimeZone(String value) {
        return String.format("'%s'", value);
    }

    @Override
    public Set<Class<? extends Exception>> getCommunicationExceptions() {
        HashSet<Class<? extends Exception>> exceptions = new HashSet<Class<? extends Exception>>();
        if (this.connectorConfig.isConnectionRestartOnErrors()) {
            exceptions.add(JDBCConnectionException.class);
        }
        return exceptions;
    }

    protected String getJdbcTypeName(int jdbcType, int length) {
        return this.getJdbcTypeName(jdbcType, Size.length((long)length));
    }

    protected String getDatabaseTimeZone(SessionFactory sessionFactory) {
        Optional<String> query = this.getDatabaseTimeZoneQuery();
        if (query.isPresent()) {
            String string;
            block9: {
                StatelessSession session = sessionFactory.openStatelessSession();
                try {
                    string = (String)session.doReturningWork(connection -> {
                        try (Statement st = connection.createStatement();
                             ResultSet rs = st.executeQuery((String)query.get());){
                            if (rs.next()) {
                                String string = this.getDatabaseTimeZoneQueryResult(rs);
                                return string;
                            }
                        }
                        return "N/A";
                    });
                    if (session == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                session.close();
            }
            return string;
        }
        return "N/A";
    }

    protected Optional<String> getDatabaseTimeZoneQuery() {
        return Optional.empty();
    }

    protected String getDatabaseTimeZoneQueryResult(ResultSet rs) throws SQLException {
        return rs.getString(1);
    }

    protected void registerTypes() {
        this.registerType(DateType.INSTANCE);
        this.registerType(TimeType.INSTANCE);
        this.registerType(MicroTimeType.INSTANCE);
        this.registerType(TimestampType.INSTANCE);
        this.registerType(MicroTimestampType.INSTANCE);
        this.registerType(NanoTimeType.INSTANCE);
        this.registerType(NanoTimestampType.INSTANCE);
        this.registerType(ZonedTimeType.INSTANCE);
        this.registerType(DebeziumZonedTimestampType.INSTANCE);
        this.registerType(VariableScaleDecimalType.INSTANCE);
        this.registerType(ConnectBooleanType.INSTANCE);
        this.registerType(ConnectBytesType.INSTANCE);
        this.registerType(ConnectDateType.INSTANCE);
        this.registerType(ConnectDecimalType.INSTANCE);
        this.registerType(ConnectFloat32Type.INSTANCE);
        this.registerType(ConnectFloat64Type.INSTANCE);
        this.registerType(ConnectInt8Type.INSTANCE);
        this.registerType(ConnectInt16Type.INSTANCE);
        this.registerType(ConnectInt32Type.INSTANCE);
        this.registerType(ConnectInt64Type.INSTANCE);
        this.registerType(ConnectStringType.INSTANCE);
        this.registerType(ConnectTimestampType.INSTANCE);
        this.registerType(ConnectTimeType.INSTANCE);
        this.registerType(ConnectMapToConnectStringType.INSTANCE);
    }

    protected void registerType(JdbcType type) {
        type.configure(this.connectorConfig, this);
        for (String key : type.getRegistrationKeys()) {
            JdbcType existing = this.typeRegistry.put(key, type);
            if (existing != null) {
                LOGGER.debug("JdbcType replaced [{}]: {} -> {}", new Object[]{key, existing.getClass().getName(), type.getClass().getName()});
                continue;
            }
            LOGGER.debug("JdbcType registered [{}]: {}", (Object)key, (Object)type.getClass().getName());
        }
    }

    protected JdbcSinkConnectorConfig getConfig() {
        return this.connectorConfig;
    }

    protected DatabaseVersion getDatabaseVersion() {
        return this.dialect.getVersion();
    }

    protected IdentifierHelper getIdentifierHelper() {
        return this.identifierHelper;
    }

    protected void addColumnDefaultValue(FieldDescriptor field, StringBuilder columnSpec) {
        String defaultValue;
        if (field.getSchema().defaultValue() != null && (defaultValue = this.getSchemaType(field.getSchema()).getDefaultValueBinding(field.getSchema(), field.getSchema().defaultValue())) != null) {
            columnSpec.append(" DEFAULT ").append(defaultValue);
        }
    }

    protected String columnQueryBindingFromField(String fieldName, TableDescriptor table, JdbcSinkRecord record) {
        FieldDescriptor field = (FieldDescriptor)record.allFields().get(fieldName);
        String columnName = this.resolveColumnName(field);
        ColumnDescriptor column = table.getColumnByName(columnName);
        Object value = record.nonKeyFieldNames().contains(fieldName) ? this.getColumnValueFromValueField(fieldName, record) : this.getColumnValueFromKeyField(fieldName, record, columnName);
        return record.jdbcFields().get(fieldName).getQueryBinding(column, value);
    }

    private Object getColumnValueFromKeyField(String fieldName, JdbcSinkRecord record, String columnName) {
        Object value;
        if (this.connectorConfig.getPrimaryKeyMode() == SinkConnectorConfig.PrimaryKeyMode.KAFKA) {
            value = this.getColumnValueForKafkaKeyMode(columnName, record);
        } else {
            Struct source = record.filteredKey();
            value = source.get(fieldName);
        }
        return value;
    }

    private Object getColumnValueFromValueField(String fieldName, JdbcSinkRecord record) {
        return record.getPayload().get(fieldName);
    }

    private Object getColumnValueForKafkaKeyMode(String columnName, JdbcSinkRecord record) {
        return switch (columnName) {
            case "__connect_topic" -> record.topicName();
            case "__connect_partition" -> record.partition();
            case "__connect_offset" -> record.offset();
            default -> null;
        };
    }

    protected String columnNameFromField(String fieldName, JdbcSinkRecord record) {
        FieldDescriptor field = (FieldDescriptor)record.allFields().get(fieldName);
        return this.toIdentifier(this.resolveColumnName(field));
    }

    protected String columnNameFromField(String fieldName, String prefix, JdbcSinkRecord record) {
        return prefix + this.columnNameFromField(fieldName, record);
    }

    protected String toIdentifier(String text) {
        Identifier identifier = this.getIdentifierHelper().toIdentifier(text, this.getConfig().isQuoteIdentifiers());
        return identifier != null ? identifier.render(this.dialect) : text;
    }

    protected String toIdentifier(CollectionId collectionId) {
        boolean quoted = this.getConfig().isQuoteIdentifiers();
        Identifier catalog = this.getIdentifierHelper().toIdentifier(collectionId.realm(), quoted);
        Identifier schema = this.getIdentifierHelper().toIdentifier(collectionId.namespace(), quoted);
        Identifier table = this.getIdentifierHelper().toIdentifier(collectionId.name(), quoted);
        if (catalog != null && schema != null && table != null) {
            return String.format("%s.%s.%s", catalog.render(this.dialect), schema.render(this.dialect), table.render(this.dialect));
        }
        if (schema != null && table != null) {
            return String.format("%s.%s", schema.render(this.dialect), table.render(this.dialect));
        }
        if (table != null) {
            return table.render(this.dialect);
        }
        throw new IllegalStateException("Expected at least table identifier to be non-null");
    }

    protected String resolveColumnNameFromField(String fieldName) {
        return this.columnNamingStrategy.resolveColumnName(fieldName);
    }

    protected boolean isIdentifierUppercaseWhenNotQuoted() {
        return false;
    }

    protected String getQualifiedTableName(CollectionId collectionId) {
        if (!Strings.isNullOrBlank((String)collectionId.namespace())) {
            return this.toIdentifier(collectionId.namespace()) + "." + this.toIdentifier(collectionId.name());
        }
        return this.toIdentifier(collectionId.name());
    }

    private String columnNameEqualsBinding(String fieldName, TableDescriptor table, JdbcSinkRecord record) {
        JdbcFieldDescriptor field = record.jdbcFields().get(fieldName);
        String columnName = this.resolveColumnName(field);
        ColumnDescriptor column = table.getColumnByName(columnName);
        return this.toIdentifier(columnName) + "=" + field.getQueryBinding(column, record.getPayload());
    }

    private static boolean isColumnNullable(String columnName, Collection<String> primaryKeyColumnNames, int nullability) {
        if (primaryKeyColumnNames.contains(columnName)) {
            return false;
        }
        return nullability != 0;
    }

    private static SessionFactoryImplementor unwrapSessionFactory(SessionFactory sessionFactory) {
        return (SessionFactoryImplementor)sessionFactory.unwrap(SessionFactoryImplementor.class);
    }
}

