/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.db2;

import io.debezium.connector.jdbc.type.debezium.DebeziumZonedTimestampType;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import io.debezium.time.ZonedTimestamp;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.List;

public class ZonedTimestampType
extends DebeziumZonedTimestampType {
    public static final ZonedTimestampType INSTANCE = new ZonedTimestampType();

    @Override
    protected List<ValueBindDescriptor> infinityTimestampValue(int index, Object value) {
        ZonedDateTime zdt = "infinity".equals(value) ? ZonedDateTime.parse(this.getDialect().getTimestampPositiveInfinityValue(), ZonedTimestamp.FORMATTER) : ZonedDateTime.parse(this.getDialect().getTimestampNegativeInfinityValue(), ZonedTimestamp.FORMATTER);
        return List.of(new ValueBindDescriptor(index, (Object)Timestamp.valueOf(zdt.toLocalDateTime())));
    }

    @Override
    protected List<ValueBindDescriptor> normalTimestampValue(int index, Object value) {
        ZonedDateTime zdt = ZonedDateTime.parse((String)value, ZonedTimestamp.FORMATTER).withZoneSameInstant(this.getDatabaseTimeZone().toZoneId());
        return List.of(new ValueBindDescriptor(index, (Object)Timestamp.from(zdt.toInstant())));
    }
}

