/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.db2.connect;

import io.debezium.connector.jdbc.type.AbstractTimestampType;
import io.debezium.connector.jdbc.util.DateTimeUtils;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;

public class ConnectTimestampType
extends AbstractTimestampType {
    public static final ConnectTimestampType INSTANCE = new ConnectTimestampType();

    public String[] getRegistrationKeys() {
        return new String[]{"org.apache.kafka.connect.data.Timestamp"};
    }

    @Override
    public String getDefaultValueBinding(Schema schema, Object value) {
        return this.getDialect().getFormattedTimestamp(DateTimeUtils.toZonedDateTimeFromDate((Date)value, ZoneOffset.UTC));
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        if (value instanceof Date) {
            LocalDateTime localDateTime = DateTimeUtils.toLocalDateTimeFromDate((Date)value);
            if (this.getDialect().isTimeZoneSet()) {
                return List.of(new ValueBindDescriptor(index, (Object)Timestamp.valueOf(localDateTime.atZone(this.getDatabaseTimeZone().toZoneId()).toLocalDateTime())));
            }
            return List.of(new ValueBindDescriptor(index, (Object)Timestamp.valueOf(localDateTime)));
        }
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value, value.getClass().getName()));
    }
}

