/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.db2.debezium;

import io.debezium.connector.jdbc.type.AbstractTimeType;
import io.debezium.sink.column.ColumnDescriptor;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;

public abstract class AbstractDebeziumTimeType
extends AbstractTimeType {
    @Override
    public String getQueryBinding(ColumnDescriptor column, Schema schema, Object value) {
        return this.getDialect().getTimeQueryBinding();
    }

    @Override
    public String getDefaultValueBinding(Schema schema, Object value) {
        LocalTime localTime = this.getLocalTime((Number)value);
        if (this.getDialect().isTimeZoneSet()) {
            return this.getDialect().getFormattedDateTime(localTime.atDate(LocalDate.now()).atZone(this.getDatabaseTimeZone().toZoneId()));
        }
        return this.getDialect().getFormattedTime(localTime);
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        if (value instanceof Number) {
            LocalTime localTime = this.getLocalTime((Number)value);
            LocalDateTime localDateTime = localTime.atDate(LocalDate.now());
            if (this.getDialect().isTimeZoneSet()) {
                return List.of(new ValueBindDescriptor(index, (Object)Timestamp.valueOf(localDateTime.atZone(this.getDatabaseTimeZone().toZoneId()).toLocalDateTime())));
            }
            return List.of(new ValueBindDescriptor(index, (Object)Timestamp.valueOf(localDateTime)));
        }
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value, value.getClass().getName()));
    }

    protected abstract LocalTime getLocalTime(Number var1);
}

