/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.mysql;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractBytesType;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;

class BytesType
extends AbstractBytesType {
    public static final BytesType INSTANCE = new BytesType();

    BytesType() {
    }

    @Override
    public String getTypeName(Schema schema, boolean isKey) {
        Optional<String> columnType = this.getSourceColumnType(schema);
        DatabaseDialect dialect = this.getDialect();
        if (columnType.isPresent()) {
            if ("TINYBLOB".equalsIgnoreCase(columnType.get())) {
                return "tinyblob";
            }
            if ("MEDIUMBLOB".equalsIgnoreCase(columnType.get())) {
                return "mediumblob";
            }
            if ("BLOB".equalsIgnoreCase(columnType.get())) {
                return "blob";
            }
            if ("LARGEBLOB".equalsIgnoreCase(columnType.get())) {
                return "largeblob";
            }
            int columnSize = Integer.parseInt(this.getSourceColumnSize(schema).orElse("0"));
            if (columnSize > 0) {
                return dialect.getJdbcTypeName(-3, Size.length((long)columnSize));
            }
        }
        return dialect.getJdbcTypeName(-3);
    }

    @Override
    public String getDefaultValueBinding(Schema schema, Object value) {
        return null;
    }
}

