/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.mysql;

import io.debezium.connector.jdbc.type.AbstractType;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EnumType
extends AbstractType {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnumType.class);
    public static final EnumType INSTANCE = new EnumType();

    EnumType() {
    }

    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.data.Enum"};
    }

    @Override
    public String getTypeName(Schema schema, boolean isKey) {
        Optional<String> allowedValues = this.getSchemaParameter(schema, "allowed");
        if (allowedValues.isPresent()) {
            String[] values = allowedValues.get().split(",");
            return "enum(" + Arrays.stream(values).map(v -> "'" + v + "'").collect(Collectors.joining(",")) + ")";
        }
        LOGGER.warn("ENUM was detected without any allowed values.");
        return "enum()";
    }
}

