/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.oracle;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractTimeType;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import io.debezium.time.ZonedTime;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;
import org.hibernate.engine.jdbc.Size;

public class ZonedTimeType
extends AbstractTimeType {
    public static final ZonedTimeType INSTANCE = new ZonedTimeType();

    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.ZonedTime"};
    }

    @Override
    public String getTypeName(Schema schema, boolean isKey) {
        int precision = this.getTimePrecision(schema);
        DatabaseDialect dialect = this.getDialect();
        if (precision > 0) {
            return dialect.getJdbcTypeName(this.getJdbcType(), Size.precision((int)precision));
        }
        return dialect.getJdbcTypeName(this.getJdbcType(), Size.precision((int)dialect.getMaxTimePrecision()));
    }

    @Override
    public String getDefaultValueBinding(Schema schema, Object value) {
        return this.getDialect().getFormattedTimeWithTimeZone((String)value);
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        if (value instanceof String) {
            ZonedDateTime zdt = OffsetTime.parse((String)value, ZonedTime.FORMATTER).atDate(LocalDate.now()).toZonedDateTime();
            if (this.getDialect().isTimeZoneSet()) {
                if (this.getDialect().shouldBindTimeWithTimeZoneAsDatabaseTimeZone()) {
                    return List.of(new ValueBindDescriptor(index, (Object)zdt.withZoneSameInstant(this.getDatabaseTimeZone().toZoneId())));
                }
                return List.of(new ValueBindDescriptor(index, (Object)zdt, Integer.valueOf(this.getJdbcType())));
            }
            return List.of(new ValueBindDescriptor(index, (Object)zdt));
        }
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value, value.getClass().getName()));
    }

    protected int getJdbcType() {
        return 2013;
    }
}

