/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.postgres;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractType;
import io.debezium.connector.jdbc.type.JdbcType;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import java.util.List;
import org.apache.kafka.connect.data.Schema;

public class ArrayType
extends AbstractType {
    public static final ArrayType INSTANCE = new ArrayType();

    public String[] getRegistrationKeys() {
        return new String[]{"ARRAY"};
    }

    @Override
    public String getTypeName(Schema schema, boolean isKey) {
        return this.getElementTypeName(this.getDialect(), schema, isKey) + "[]";
    }

    private String getElementTypeName(DatabaseDialect dialect, Schema schema, boolean isKey) {
        JdbcType elementJdbcType = dialect.getSchemaType(schema.valueSchema());
        return elementJdbcType.getTypeName(schema.valueSchema(), isKey);
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        return List.of(new ValueBindDescriptor(index, value, Integer.valueOf(2003), this.getElementTypeName(this.getDialect(), schema, false)));
    }
}

