/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.postgres;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractBytesType;
import io.debezium.connector.jdbc.util.ByteArrayUtils;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;

class BytesType
extends AbstractBytesType {
    public static final BytesType INSTANCE = new BytesType();

    BytesType() {
    }

    @Override
    public String getDefaultValueBinding(Schema schema, Object value) {
        return String.format(this.getDialect().getByteArrayFormat(), ByteArrayUtils.getByteArrayAsHex(value));
    }

    @Override
    public String getTypeName(Schema schema, boolean isKey) {
        int columnSize = Integer.parseInt(this.getSourceColumnSize(schema).orElse("0"));
        DatabaseDialect dialect = this.getDialect();
        if (columnSize > 0) {
            return dialect.getJdbcTypeName(-3, Size.length((long)columnSize));
        }
        if (isKey) {
            return dialect.getJdbcTypeName(-3, Size.length((long)dialect.getMaxVarbinaryLength()));
        }
        return dialect.getJdbcTypeName(-3);
    }
}

