/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.postgres;

import io.debezium.connector.jdbc.type.AbstractType;
import io.debezium.sink.column.ColumnDescriptor;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import java.util.List;
import org.apache.kafka.connect.data.Schema;

class IntervalType
extends AbstractType {
    public static final IntervalType INSTANCE = new IntervalType();

    IntervalType() {
    }

    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.MicroDuration"};
    }

    @Override
    public String getQueryBinding(ColumnDescriptor column, Schema schema, Object value) {
        return "cast(? as interval)";
    }

    @Override
    public String getTypeName(Schema schema, boolean isKey) {
        return "interval";
    }

    @Override
    public String getDefaultValueBinding(Schema schema, Object value) {
        if (value instanceof Long) {
            double doubleValue = ((Long)value).doubleValue() / 1000000.0;
            return String.format("'%d seconds'", (long)doubleValue);
        }
        return null;
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value != null && Long.class.isAssignableFrom(value.getClass())) {
            double doubleValue = ((Long)value).doubleValue() / 1000000.0;
            return List.of(new ValueBindDescriptor(index, (Object)((long)doubleValue + " seconds")));
        }
        return super.bind(index, schema, value);
    }
}

