/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.postgres;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.JdbcSinkRecord;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.dialect.DatabaseDialectProvider;
import io.debezium.connector.jdbc.dialect.GeneralDatabaseDialect;
import io.debezium.connector.jdbc.dialect.SqlStatementBuilder;
import io.debezium.connector.jdbc.dialect.postgres.ArrayType;
import io.debezium.connector.jdbc.dialect.postgres.BitType;
import io.debezium.connector.jdbc.dialect.postgres.BytesType;
import io.debezium.connector.jdbc.dialect.postgres.CaseInsensitiveTextType;
import io.debezium.connector.jdbc.dialect.postgres.CidrType;
import io.debezium.connector.jdbc.dialect.postgres.DoubleVectorType;
import io.debezium.connector.jdbc.dialect.postgres.EnumType;
import io.debezium.connector.jdbc.dialect.postgres.FloatVectorType;
import io.debezium.connector.jdbc.dialect.postgres.GeographyType;
import io.debezium.connector.jdbc.dialect.postgres.GeometryType;
import io.debezium.connector.jdbc.dialect.postgres.InetType;
import io.debezium.connector.jdbc.dialect.postgres.IntervalType;
import io.debezium.connector.jdbc.dialect.postgres.JsonType;
import io.debezium.connector.jdbc.dialect.postgres.LtreeType;
import io.debezium.connector.jdbc.dialect.postgres.MacAddressType;
import io.debezium.connector.jdbc.dialect.postgres.MapToHstoreType;
import io.debezium.connector.jdbc.dialect.postgres.MoneyType;
import io.debezium.connector.jdbc.dialect.postgres.OidType;
import io.debezium.connector.jdbc.dialect.postgres.PointType;
import io.debezium.connector.jdbc.dialect.postgres.RangeType;
import io.debezium.connector.jdbc.dialect.postgres.SerialType;
import io.debezium.connector.jdbc.dialect.postgres.SparseDoubleVectorType;
import io.debezium.connector.jdbc.dialect.postgres.TimeWithTimezoneType;
import io.debezium.connector.jdbc.dialect.postgres.UuidType;
import io.debezium.connector.jdbc.dialect.postgres.XmlType;
import io.debezium.connector.jdbc.dialect.postgres.ZonedTimestampType;
import io.debezium.connector.jdbc.relational.TableDescriptor;
import io.debezium.connector.jdbc.type.JdbcType;
import io.debezium.metadata.CollectionId;
import io.debezium.sink.column.ColumnDescriptor;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQLDialect;

public class PostgresDatabaseDialect
extends GeneralDatabaseDialect {
    private PostgresDatabaseDialect(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
        super(config, sessionFactory);
    }

    @Override
    public int getMaxTimestampPrecision() {
        return 6;
    }

    @Override
    public boolean tableExists(Connection connection, CollectionId collectionId) throws SQLException {
        if (!this.getConfig().isQuoteIdentifiers()) {
            collectionId = collectionId.toLowerCase();
        }
        return super.tableExists(connection, collectionId);
    }

    @Override
    public TableDescriptor readTable(Connection connection, CollectionId collectionId) throws SQLException {
        if (!this.getConfig().isQuoteIdentifiers()) {
            collectionId = collectionId.toLowerCase();
        }
        return super.readTable(connection, collectionId);
    }

    @Override
    public String getAlterTablePrefix() {
        return "";
    }

    @Override
    public String getAlterTableSuffix() {
        return "";
    }

    @Override
    public String getAlterTableColumnPrefix() {
        return "ADD COLUMN ";
    }

    @Override
    public String getUpsertStatement(TableDescriptor table, JdbcSinkRecord record) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getQualifiedTableName(table.getId()));
        builder.append(" (");
        builder.appendLists(",", record.keyFieldNames(), record.nonKeyFieldNames(), name -> this.columnNameFromField((String)name, record));
        builder.append(") VALUES (");
        builder.appendLists(",", record.keyFieldNames(), record.nonKeyFieldNames(), name -> this.columnQueryBindingFromField((String)name, table, record));
        builder.append(") ON CONFLICT (");
        builder.appendList(",", record.keyFieldNames(), name -> this.columnNameFromField((String)name, record));
        if (record.nonKeyFieldNames().isEmpty()) {
            builder.append(") DO NOTHING");
        } else {
            builder.append(") DO UPDATE SET ");
            builder.appendList(",", record.nonKeyFieldNames(), name -> {
                String columnNme = this.columnNameFromField((String)name, record);
                return columnNme + "=EXCLUDED." + columnNme;
            });
        }
        return builder.build();
    }

    @Override
    public String getQueryBindingWithValueCast(ColumnDescriptor column, Schema schema, JdbcType type) {
        if (schema.type() == Schema.Type.STRING) {
            String typeName = column.getTypeName().toLowerCase();
            if ("uuid".equals(typeName)) {
                return "cast(? as uuid)";
            }
            if ("json".equals(typeName)) {
                return "cast(? as json)";
            }
            if ("jsonb".equals(typeName)) {
                return "cast(? as jsonb)";
            }
        }
        return super.getQueryBindingWithValueCast(column, schema, type);
    }

    @Override
    public String getByteArrayFormat() {
        return "'\\x%s'";
    }

    @Override
    public String getFormattedBoolean(boolean value) {
        return value ? "TRUE" : "FALSE";
    }

    @Override
    public String getFormattedDateTimeWithNanos(TemporalAccessor value) {
        return String.format("'%s'", DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(value));
    }

    @Override
    public String getFormattedTime(TemporalAccessor value) {
        return String.format("'%s'", DateTimeFormatter.ISO_LOCAL_TIME.format(value));
    }

    @Override
    protected Optional<String> getDatabaseTimeZoneQuery() {
        return Optional.of("SELECT CURRENT_SETTING('TIMEZONE')");
    }

    @Override
    protected void registerTypes() {
        super.registerTypes();
        this.registerType(TimeWithTimezoneType.INSTANCE);
        this.registerType(ZonedTimestampType.INSTANCE);
        this.registerType(IntervalType.INSTANCE);
        this.registerType(SerialType.INSTANCE);
        this.registerType(BitType.INSTANCE);
        this.registerType(BytesType.INSTANCE);
        this.registerType(JsonType.INSTANCE);
        this.registerType(UuidType.INSTANCE);
        this.registerType(EnumType.INSTANCE);
        this.registerType(PointType.INSTANCE);
        this.registerType(GeometryType.INSTANCE);
        this.registerType(GeographyType.INSTANCE);
        this.registerType(MoneyType.INSTANCE);
        this.registerType(XmlType.INSTANCE);
        this.registerType(LtreeType.INSTANCE);
        this.registerType(MapToHstoreType.INSTANCE);
        this.registerType(ArrayType.INSTANCE);
        this.registerType(RangeType.INSTANCE);
        this.registerType(CidrType.INSTANCE);
        this.registerType(MacAddressType.INSTANCE);
        this.registerType(InetType.INSTANCE);
        this.registerType(CaseInsensitiveTextType.INSTANCE);
        this.registerType(OidType.INSTANCE);
        this.registerType(SparseDoubleVectorType.INSTANCE);
        this.registerType(FloatVectorType.INSTANCE);
        this.registerType(DoubleVectorType.INSTANCE);
    }

    @Override
    public int getMaxVarcharLengthInKey() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected String resolveColumnNameFromField(String fieldName) {
        String columnName = super.resolveColumnNameFromField(fieldName);
        if (!this.getConfig().isQuoteIdentifiers() && !this.getIdentifierHelper().toIdentifier(columnName).isQuoted()) {
            columnName = columnName.toLowerCase();
        }
        return columnName;
    }

    @Override
    public String getTimestampPositiveInfinityValue() {
        return "infinity";
    }

    @Override
    public String getTimestampNegativeInfinityValue() {
        return "-infinity";
    }

    public static class PostgresDatabaseDialectProvider
    implements DatabaseDialectProvider {
        @Override
        public boolean supports(Dialect dialect) {
            return dialect instanceof PostgreSQLDialect;
        }

        @Override
        public Class<?> name() {
            return PostgresDatabaseDialect.class;
        }

        @Override
        public DatabaseDialect instantiate(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
            return new PostgresDatabaseDialect(config, sessionFactory);
        }
    }
}

