/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.postgres;

import io.debezium.connector.jdbc.type.AbstractType;
import io.debezium.sink.column.ColumnDescriptor;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import java.util.List;
import org.apache.kafka.connect.data.Schema;

class RangeType
extends AbstractType {
    public static final RangeType INSTANCE = new RangeType();

    RangeType() {
    }

    public String[] getRegistrationKeys() {
        return new String[]{"INT4RANGE", "INT8RANGE", "NUMRANGE", "TSRANGE", "TSTZRANGE", "DATERANGE"};
    }

    @Override
    public String getQueryBinding(ColumnDescriptor column, Schema schema, Object value) {
        return "cast(? as " + this.getSourceColumnType(schema).orElseThrow() + ")";
    }

    @Override
    public String getTypeName(Schema schema, boolean isKey) {
        return this.getSourceColumnType(schema).orElseThrow();
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        String finalValue = value == null ? null : ((String)value).replaceAll("\"", "");
        return List.of(new ValueBindDescriptor(index, (Object)finalValue));
    }
}

