/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.sqlserver;

import io.debezium.connector.jdbc.type.AbstractBytesType;
import io.debezium.connector.jdbc.util.ByteArrayUtils;
import io.debezium.sink.column.ColumnDescriptor;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;
import org.hibernate.engine.jdbc.Size;

class BytesType
extends AbstractBytesType {
    public static final BytesType INSTANCE = new BytesType();

    BytesType() {
    }

    @Override
    public String getDefaultValueBinding(Schema schema, Object value) {
        return String.format(this.getDialect().getByteArrayFormat(), ByteArrayUtils.getByteArrayAsHex(value));
    }

    @Override
    public String getTypeName(Schema schema, boolean isKey) {
        int columnSize = Integer.parseInt(this.getSourceColumnSize(schema).orElse("0"));
        if (columnSize > 0) {
            return this.getDialect().getJdbcTypeName(-3, Size.length((long)columnSize));
        }
        if (isKey) {
            return this.getDialect().getJdbcTypeName(-3, Size.length((long)this.getDialect().getMaxVarbinaryLength()));
        }
        return this.getDialect().getJdbcTypeName(-3);
    }

    @Override
    public String getQueryBinding(ColumnDescriptor column, Schema schemas, Object value) {
        return "convert(varbinary(max),?,1)";
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schemas, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        if (value instanceof ByteBuffer) {
            return List.of(new ValueBindDescriptor(index, (Object)((ByteBuffer)value).array()));
        }
        if (value instanceof byte[]) {
            return List.of(new ValueBindDescriptor(index, value));
        }
        throw new ConnectException(String.format("Unexpected %s value '%s' with type'%s'", this.getClass().getSimpleName(), value, value.getClass().getSimpleName()));
    }
}

